/*
 * Decompiled with CFR 0.152.
 */
package com.walker.db.page;

import com.walker.db.page.GenericPager;
import com.walker.db.page.Pager;
import com.walker.infrastructure.utils.StringUtils;
import java.io.Serializable;
import java.util.List;

public class PagerView<T>
implements Serializable {
    private static final long serialVersionUID = -7447015048488224271L;
    private List<T> datas;
    private int currentPage = 1;
    private int pageSize = 1;
    private int pageCount = 1;
    private long totalRows = 0L;
    private String jsMethod;
    private long index = 0L;

    public PagerView(Pager pager, String jsMethod) {
        if (StringUtils.isNotEmpty(jsMethod)) {
            this.jsMethod = jsMethod;
        }
        this.setPager(pager);
    }

    public PagerView(String jsMethod) {
        if (StringUtils.isNotEmpty(jsMethod)) {
            this.jsMethod = jsMethod;
        }
    }

    public void setPager(Pager pager) {
        if (pager == null) {
            throw new IllegalArgumentException("Please use subclass of '" + Pager.class.getName() + "'.");
        }
        this.setCurrentPage(pager.getPageIndex());
        this.setTotalRows(pager.getTotalRows());
        this.setPageSize(pager.getPageSize());
        this.setPageCount(pager.getPageCount());
        this.setIndex(pager.getFirstRowIndexInPage());
        if (!(pager instanceof GenericPager)) {
            throw new IllegalArgumentException("unknown Pager: " + pager.getClass().getName());
        }
        GenericPager genericPager = (GenericPager)pager;
        this.setDatas(genericPager.getDatas());
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public String getJsMethod() {
        return this.jsMethod;
    }

    public long getIndex() {
        return this.index;
    }

    private void setCurrentPage(int currentPage) {
        if (currentPage < 1) {
            throw new IllegalArgumentException("currentPage should be >= 1");
        }
        this.currentPage = currentPage;
    }

    private void setTotalRows(long totalRows) {
        if (totalRows < 0L) {
            throw new IllegalArgumentException("totalRows should be more than or equals '0'.");
        }
        this.totalRows = totalRows;
    }

    private void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize should be >= 1");
        }
        this.pageSize = pageSize;
    }

    private void setPageCount(int pageCount) {
        if (pageCount < 1) {
            throw new IllegalArgumentException("pageCount should be >= 1");
        }
        this.pageCount = pageCount;
    }

    private void setDatas(List<T> datas) {
        this.datas = datas;
    }

    private void setIndex(long index) {
        if (index > 0L) {
            this.index = index;
        }
    }
}

