/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments;

import com.walker.infrastructure.arguments.ArgumentsException;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.support.XmlArgumentsManager;
import com.walker.infrastructure.utils.StringUtils;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ArgumentsManagerFactory {
    private static final ConcurrentHashMap<String, ArgumentsManager> existArgumentsManagers = new ConcurrentHashMap(2);

    public static final ArgumentsManager createXmlArgumentsManager(String filename, boolean classpath) {
        assert (StringUtils.isNotEmpty(filename));
        ArgumentsManager exist = existArgumentsManagers.get(filename);
        if (exist != null) {
            throw new ArgumentsException("\u5df2\u7ecf\u5b58\u5728\u914d\u7f6e\u7ba1\u7406\u5668\uff0c\u65e0\u6cd5\u91cd\u590d\u521b\u5efa: " + filename);
        }
        XmlArgumentsManager xmlArgumentsManager = new XmlArgumentsManager();
        if (classpath) {
            xmlArgumentsManager.setClasspathFileName(filename);
        } else {
            xmlArgumentsManager.setFileSystemFileName(filename);
        }
        try {
            xmlArgumentsManager.afterPropertiesSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArgumentsException("\u521d\u59cb\u5316ArgumentManager\u5931\u8d25: " + filename, e);
        }
        existArgumentsManagers.put(filename, xmlArgumentsManager);
        return xmlArgumentsManager;
    }

    public static final ArgumentsManager getArgumentsManager(String filename) {
        ArgumentsManager exist = existArgumentsManagers.get(filename);
        if (exist == null) {
            throw new ArgumentsException("not found argumentsManager\uff1a" + filename);
        }
        return exist;
    }

    public static final void destroy() {
        for (ArgumentsManager am : existArgumentsManagers.values()) {
            try {
                am.destroy();
            }
            catch (Exception ex) {
                throw new ArgumentsException("\u9500\u6bc1ArgumentsManager\u5931\u8d25: " + am.toString(), ex);
            }
        }
    }
}

