/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments;

import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.ArgumentsManagerAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ArgumentsPostProcessor
implements BeanPostProcessor {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArgumentsManager argumentsManager;

    public void setArgumentsManager(ArgumentsManager argumentsManager) {
        this.argumentsManager = argumentsManager;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ArgumentsManagerAware.class.isAssignableFrom(bean.getClass())) {
            if (this.argumentsManager == null) {
                throw new IllegalStateException("argumentsManager is required!");
            }
            ((ArgumentsManagerAware)bean).setArgumentManager(this.argumentsManager);
            this.logger.info("........inject argumentsManager into: " + beanName);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

