/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments.support;

import com.walker.infrastructure.arguments.ArgumentsException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.VariableType;
import com.walker.infrastructure.utils.StringUtils;

public class DefaultVariable
implements Variable {
    private String id;
    private String description = "";
    private VariableType type;
    private String stringValue;
    private int integerValue = 0;
    private boolean booleanValue = false;
    private float floatValue = 0.0f;
    private long longValue = 0L;
    private double doubleValue = 0.0;
    private Object defaultValue = null;

    public DefaultVariable() {
    }

    public DefaultVariable(VariableType type, Object value, Object defaultValue) {
        assert (type != null);
        assert (value != null);
        this.type = type;
        this.defaultValue = defaultValue;
        this.setValue(value);
    }

    public DefaultVariable setType(VariableType type) {
        this.type = type;
        return this;
    }

    public DefaultVariable setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DefaultVariable setValue(Object value) {
        assert (this.type != null);
        if (this.type == VariableType.Integer) {
            this.integerValue = Integer.parseInt(value.toString());
        } else if (this.type == VariableType.Boolean) {
            this.booleanValue = Boolean.valueOf(value.toString());
        } else if (this.type == VariableType.Float) {
            this.floatValue = Float.parseFloat(value.toString());
        } else if (this.type == VariableType.String) {
            this.stringValue = value.toString();
        } else if (this.type == VariableType.Long) {
            this.longValue = Long.parseLong(value.toString());
        } else if (this.type == VariableType.Double) {
            this.doubleValue = Double.parseDouble(value.toString());
        } else {
            throw new IllegalArgumentException("unsupported primitive type in value: " + value);
        }
        return this;
    }

    public DefaultVariable setId(String id) {
        assert (StringUtils.isNotEmpty(id));
        this.id = id;
        return this;
    }

    public DefaultVariable setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public VariableType getType() {
        return this.type;
    }

    @Override
    public String getStringValue() {
        if (this.type != VariableType.String) {
            throw new ArgumentsException("error invoke in getStringValue(), type: " + this.type);
        }
        return this.stringValue;
    }

    @Override
    public int getIntegerValue() {
        if (this.type != VariableType.Integer) {
            throw new ArgumentsException("error invoke in getStringValue(), type: " + this.type);
        }
        return this.integerValue;
    }

    @Override
    public boolean getBooleanValue() {
        if (this.type != VariableType.Boolean) {
            throw new ArgumentsException("error invoke in getStringValue(), type: " + this.type);
        }
        return this.booleanValue;
    }

    @Override
    public float getFloatValue() {
        if (this.type != VariableType.Float) {
            throw new ArgumentsException("error invoke in getStringValue(), type: " + this.type);
        }
        return this.floatValue;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        if (this.type == VariableType.String) {
            return this.defaultValue.toString();
        }
        if (this.type == VariableType.Integer) {
            return Integer.parseInt(this.defaultValue.toString());
        }
        if (this.type == VariableType.Boolean) {
            return Boolean.valueOf(this.defaultValue.toString());
        }
        if (this.type == VariableType.Float) {
            return Float.valueOf(Float.parseFloat(this.defaultValue.toString()));
        }
        if (this.type == VariableType.Long) {
            return Long.parseLong(this.defaultValue.toString());
        }
        throw new IllegalArgumentException("unsupported defaultValue type: " + this.defaultValue.getClass());
    }

    public String toString() {
        return "{" + "id = " + this.id + ", desc = " + this.description + ", type = " + (Object)((Object)this.type) + "}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof DefaultVariable) {
            DefaultVariable dv = (DefaultVariable)o;
            if (dv.id.equals(this.id) && dv.description.equals(this.description) && dv.type == this.type) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 + 31 * this.id.hashCode() + this.description.hashCode() + this.type.hashCode();
    }

    @Override
    public long getLongValue() {
        return this.longValue;
    }

    @Override
    public double getDoubleValue() {
        return this.doubleValue;
    }
}

