/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments.support;

import com.walker.infrastructure.arguments.AbstractArgumentsManager;
import com.walker.infrastructure.arguments.ArgumentsException;
import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;

public abstract class FileArgumentsManager
extends AbstractArgumentsManager {
    private String classPathFileName;
    private String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setClasspathFileName(String fileName) {
        assert (StringUtils.isNotEmpty(fileName));
        this.classPathFileName = fileName;
    }

    public void setFileSystemFileName(String absoluteFilename) {
        assert (StringUtils.isNotEmpty(absoluteFilename));
        this.filePath = absoluteFilename;
    }

    @Override
    protected List<Group> load(Object source) throws Exception {
        FileSystemResource variableRes = null;
        if (StringUtils.isNotEmpty(this.filePath)) {
            variableRes = new FileSystemResource(new File(this.filePath));
        } else if (StringUtils.isNotEmpty(this.classPathFileName)) {
            variableRes = new ClassPathResource(this.classPathFileName);
            this.filePath = variableRes.getFile().getAbsolutePath();
        } else {
            throw new ArgumentsException("\u53ef\u53d8\u53c2\u6570\u914d\u7f6e\u6587\u4ef6\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u6587\u4ef6\u540d\uff0c\u53ef\u4ee5\u5728\u7c7b\u8def\u5f84\u4e0b\u4e5f\u53ef\u4ee5\u662f\u7edd\u5bf9\u8def\u5f84!");
        }
        InputStream input = variableRes.getInputStream();
        if (input == null) {
            throw new ArgumentsException("file not found: " + variableRes.getFilename());
        }
        return this.loadFile(input);
    }

    protected abstract List<Group> loadFile(InputStream var1) throws Exception;
}

