/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.arguments.support;

import com.walker.infrastructure.arguments.ArgumentsException;
import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.VariableType;
import com.walker.infrastructure.arguments.support.DefaultGroup;
import com.walker.infrastructure.arguments.support.DefaultVariable;
import com.walker.infrastructure.arguments.support.FileArgumentsManager;
import com.walker.infrastructure.core.DomParser;
import com.walker.infrastructure.core.domx.Dom4jParser;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.WorkingTimeTester;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlArgumentsManager
extends FileArgumentsManager {
    private final DomParser<Document> domParser = new Dom4jParser();
    private Document document;
    private final OutputFormat format = OutputFormat.createPrettyPrint();
    private static final String GROUP_NAME = "group";
    private static final String GROUP_ID_ATTR = "id";
    private static final String GROUP_NAME_ATTR = "name";
    private static final String GROUP_ORDER_ATTR = "order";
    private static final String VAR_NAME = "variable";
    private static final String VAR_ID_ATTR = "id";
    private static final String VAR_NAME_ATTR = "name";
    private static final String VAR_TYPE_ATTR = "type";
    private static final String VAR_VALUE_ATTR = "value";
    private static final String VAR_DEFAULT_ATTR = "default";

    @Override
    protected List<Group> loadFile(InputStream inputStream) throws Exception {
        this.document = this.domParser.getDocumentFromStream(inputStream);
        Element e = this.document.getRootElement();
        if (e == null) {
            return null;
        }
        ArrayList<Group> groupList = new ArrayList<Group>(8);
        Iterator j = e.elementIterator();
        while (j.hasNext()) {
            groupList.add(this.loadGroups((Element)j.next()));
        }
        return groupList;
    }

    private Group loadGroups(Element groupElement) {
        String name = groupElement.getName().toLowerCase();
        if (!name.equalsIgnoreCase(GROUP_NAME)) {
            throw new IllegalArgumentException("unsupported group name: " + name);
        }
        DefaultGroup _group = new DefaultGroup();
        Attribute attr = null;
        Iterator a = groupElement.attributeIterator();
        while (a.hasNext()) {
            attr = (Attribute)a.next();
            if (attr.getName().equalsIgnoreCase("id")) {
                _group.setId(attr.getValue().trim());
                continue;
            }
            if (attr.getName().equalsIgnoreCase("name")) {
                _group.setName(attr.getValue().trim());
                continue;
            }
            if (!attr.getName().equalsIgnoreCase(GROUP_ORDER_ATTR)) continue;
            _group.setOrder(Integer.parseInt(attr.getValue().trim()));
        }
        List<Variable> list = this.loadVariables(groupElement);
        _group.setChildren(list);
        this.logger.info("--------------------- \u3010\u5f00\u59cb\u3011\u52a0\u8f7d\u53c2\u6570\u5206\u7ec4\uff1a" + name);
        for (Variable v : list) {
            this.logger.info(v.toString());
        }
        return _group;
    }

    private List<Variable> loadVariables(Element groupElement) {
        if (groupElement.elements() != null) {
            Element varElement = null;
            ArrayList<Variable> varList = new ArrayList<Variable>(groupElement.elements().size());
            Iterator j = groupElement.elementIterator();
            while (j.hasNext()) {
                varElement = (Element)j.next();
                if (varElement.getName().equalsIgnoreCase(VAR_NAME)) {
                    Attribute attr = null;
                    DefaultVariable variable = new DefaultVariable();
                    Iterator a = varElement.attributeIterator();
                    while (a.hasNext()) {
                        attr = (Attribute)a.next();
                        if (attr.getName().equalsIgnoreCase("id")) {
                            variable.setId(attr.getValue().trim());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase("name")) {
                            variable.setDescription(attr.getValue().trim());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(VAR_TYPE_ATTR)) {
                            variable.setType(VariableType.getType(attr.getValue().trim()));
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(VAR_VALUE_ATTR)) {
                            variable.setValue(attr.getValue().trim());
                            continue;
                        }
                        if (attr.getName().equalsIgnoreCase(VAR_DEFAULT_ATTR)) {
                            variable.setDefaultValue(attr.getValue().trim());
                            continue;
                        }
                        throw new IllegalArgumentException("unsupported variable attribute: " + attr.getName());
                    }
                    varList.add(variable);
                    continue;
                }
                throw new IllegalArgumentException("unsupported variable name: " + varElement.getName());
            }
            return varList;
        }
        return null;
    }

    @Override
    protected void saveVariable(String groupId, String variableId, Object value) throws Exception {
        this.updateDocument(groupId, variableId, value);
        this.writeFile();
    }

    @Override
    protected void saveVariables(List<Object[]> changedList) throws Exception {
        for (Object[] args : changedList) {
            this.updateDocument(args[0].toString(), args[1].toString(), args[2]);
        }
        this.writeFile();
    }

    @Override
    protected void insertVariables(List<Object[]> insertList) throws Exception {
        Element root = null;
        Group group = null;
        Variable variable = null;
        for (Object[] objects : insertList) {
            Node varNode;
            group = (Group)objects[0];
            variable = (Variable)objects[1];
            Node node = this.document.selectSingleNode(this.getGroupNodeString(group.getId()));
            if (node == null) {
                this.logger.debug("group\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa: " + group);
                root = this.document.getRootElement();
                Element groupElement = root.addElement(GROUP_NAME);
                groupElement.addAttribute("id", group.getId());
                groupElement.addAttribute("name", group.getName());
                groupElement.addAttribute(GROUP_ORDER_ATTR, String.valueOf(group.getOrder()));
                node = groupElement;
            }
            if ((varNode = this.document.selectSingleNode(this.getVariableNodeString(group.getId(), variable.getId()))) != null) {
                this.logger.warn("variable is exist, it can't be added: " + variable);
                continue;
            }
            Element varElement = ((Element)node).addElement(VAR_NAME);
            varElement.addAttribute("id", variable.getId());
            varElement.addAttribute("name", variable.getDescription());
            varElement.addAttribute(VAR_TYPE_ATTR, variable.getType().getTypeName());
            if (variable.getType() == VariableType.String) {
                varElement.addAttribute(VAR_VALUE_ATTR, variable.getStringValue());
            } else if (variable.getType() == VariableType.Boolean) {
                varElement.addAttribute(VAR_VALUE_ATTR, String.valueOf(variable.getBooleanValue()));
            } else if (variable.getType() == VariableType.Integer) {
                varElement.addAttribute(VAR_VALUE_ATTR, String.valueOf(variable.getIntegerValue()));
            } else if (variable.getType() == VariableType.Float) {
                varElement.addAttribute(VAR_VALUE_ATTR, String.valueOf(variable.getFloatValue()));
            } else if (variable.getType() == VariableType.Long) {
                varElement.addAttribute(VAR_VALUE_ATTR, String.valueOf(variable.getLongValue()));
            }
            varElement.addAttribute(VAR_DEFAULT_ATTR, variable.getDefaultValue().toString());
        }
        this.writeFile();
    }

    private String getGroupNodeString(String groupId) {
        StringBuilder path = new StringBuilder("root/");
        path.append("group[@id='");
        path.append(groupId);
        path.append("']");
        return path.toString();
    }

    private String getVariableNodeString(String groupId, String variableId) {
        StringBuilder path = new StringBuilder("root/");
        path.append("group[@id='");
        path.append(groupId);
        path.append("']/variable[@id='");
        path.append(variableId);
        path.append("']");
        return path.toString();
    }

    private void updateDocument(String groupId, String variableId, Object value) {
        assert (StringUtils.isNotEmpty(groupId));
        assert (StringUtils.isNotEmpty(variableId));
        assert (value != null);
        Node node = this.document.selectSingleNode(this.getVariableNodeString(groupId, variableId));
        if (node == null) {
            throw new RuntimeException("Node not found: " + groupId + " --> " + variableId);
        }
        this.logger.debug("node = " + node.asXML());
        Element element = (Element)node;
        element.addAttribute(VAR_VALUE_ATTR, value.toString());
    }

    private void writeFile() {
        XMLWriter output = null;
        this.format.setEncoding("UTF-8");
        try {
            output = new XMLWriter((OutputStream)new FileOutputStream(this.getFilePath()), this.format);
            output.write(this.document);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ArgumentsException("\u5199\u5165\u6587\u4ef6\u51fa\u73b0\u9519\u8bef: " + e.getMessage(), e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.getFilePath();
    }

    public static void main(String[] args) throws Exception {
        XmlArgumentsManager argumentManager = new XmlArgumentsManager();
        argumentManager.setClasspathFileName("variable.xml");
        argumentManager.setSource("test");
        argumentManager.afterPropertiesSet();
        System.out.println(argumentManager.getVariableList("SYSTEM.SUPERPASS"));
        System.out.println("+++ \u5206\u7ec4\u4fe1\u606f: " + argumentManager.getGroupList());
        WorkingTimeTester tester = new WorkingTimeTester("var");
        Variable var = argumentManager.getVariable("11");
        System.out.println("--\u5206\u9875\u6570\uff1a" + var.getIntegerValue());
        tester.stop();
        Object[] args1 = new Object[]{"1", "11", 88};
        Object[] args2 = new Object[]{"2", "21", "\u4fee\u6539\u8fc7\u4f01\u4e1a\u540d\u79f0"};
        ArrayList<Object[]> argList = new ArrayList<Object[]>();
        argList.add(args1);
        argList.add(args2);
        argumentManager.persist(argList);
        Variable v2 = argumentManager.getVariable("21");
        System.out.println("\u4fee\u6539\u540e\u7f13\u5b58: " + v2.getStringValue());
        DefaultGroup group2 = new DefaultGroup();
        group2.setId("testGroup2");
        group2.setName("\u7cfb\u7edf\u63d0\u9192");
        group2.setOrder(8);
        DefaultVariable v = new DefaultVariable();
        v.setId("smtp.mail.address");
        v.setDescription("\u90ae\u4ef6\u53d1\u9001\u5730\u5740");
        v.setType(VariableType.String);
        v.setValue("smtp.163.com");
        v.setDefaultValue("smtp.mymail.net");
        ArrayList<Object[]> insertList = new ArrayList<Object[]>();
        insertList.add(new Object[]{group2, v});
        argumentManager.insert(insertList);
    }
}

