/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.core.domx;

import com.walker.infrastructure.core.DomParser;
import com.walker.infrastructure.core.domx.XmlParseException;
import com.walker.infrastructure.utils.WorkingTimeTester;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.SAXReader;
import org.dom4j.io.STAXEventReader;

public class Dom4jParser
implements DomParser<Document> {
    private final DocumentFactory factory = new DocumentFactory();
    private STAXEventReader stax = new STAXEventReader(this.factory);
    private SAXReader saxReader = new SAXReader();

    @Override
    public Document getDocumentFromXml(String xml) {
        if (xml == null) {
            return null;
        }
        Document doc = null;
        StringReader sreader = null;
        try {
            sreader = new StringReader(xml);
            doc = this.stax.readDocument((Reader)sreader);
        }
        catch (XMLStreamException e) {
            throw new XmlParseException(xml);
        }
        finally {
            try {
                if (sreader != null) {
                    ((Reader)sreader).close();
                }
            }
            catch (Exception exception) {}
        }
        return doc;
    }

    @Override
    public boolean isSupported(Class<Object> clazz) {
        return false;
    }

    @Override
    public Document getDocumentFromStream(InputStream inputStream) {
        try {
            return this.saxReader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new RuntimeException("Document create error!");
        }
    }

    public static void main(String[] args) {
        final StringBuilder XML_INSERT = new StringBuilder();
        XML_INSERT.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XML_INSERT.append("<Root>");
        XML_INSERT.append("<ReqType id=\"myid\">input</ReqType>");
        XML_INSERT.append("<SessionID>\u4f1a\u8bddID</SessionID>");
        XML_INSERT.append("<Version>\u5f53\u524d\u6570\u636e\u5f55\u5165\u64cd\u4f5c\u534f\u8bae\u7248\u672c</Version>");
        XML_INSERT.append("<TransactionType>\u4e8b\u52a1\u7c7b\u578b(\u9ed8\u8ba4\u4e3a1)</TransactionType>");
        XML_INSERT.append("</Root>");
        final Dom4jParser parser = new Dom4jParser();
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                @Override
                public void run() {
                    WorkingTimeTester wtt = new WorkingTimeTester();
                    Document document = parser.getDocumentFromXml(XML_INSERT.toString());
                    wtt.stop();
                    System.out.println("============ " + document.toString());
                }
            }.start();
        }
    }
}

