/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ByteTools {
    private static char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getRandomNum(int intNumber) {
        StringBuilder sb = new StringBuilder("");
        Random random = new Random();
        for (int i = 0; i < intNumber; ++i) {
            sb.append(String.valueOf(random.nextInt(10)));
        }
        return sb.toString();
    }

    public static String byteHEX(byte ib) {
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static int byte2int(byte byHi, byte byLo) {
        return (byHi & 0xFF) << 8 | byLo & 0xFF;
    }

    public static int byte2int(byte HH, byte HL, byte LH, byte LL) {
        return (HH & 0xFF) << 24 | (HL & 0xFF) << 16 | (LH & 0xFF) << 8 | LL & 0xFF;
    }

    public static byte[] int2bytes(int i) {
        byte[] abyte0 = new byte[4];
        abyte0[3] = (byte)(0xFF & i);
        abyte0[2] = (byte)((0xFF00 & i) >> 8);
        abyte0[1] = (byte)((0xFF0000 & i) >> 16);
        abyte0[0] = (byte)((0xFF000000 & i) >> 24);
        return abyte0;
    }

    public static byte[] int2bytes2(int i) {
        byte[] abyte0 = new byte[2];
        abyte0[1] = (byte)(0xFF & i);
        abyte0[0] = (byte)((0xFF00 & i) >> 8);
        return abyte0;
    }

    public static int bytes2int(byte[] b) {
        int res = 0;
        res <<= 8;
        res |= b[0] & 0xFF;
        res <<= 8;
        res |= b[1] & 0xFF;
        res <<= 8;
        res |= b[2] & 0xFF;
        res <<= 8;
        return res |= b[3] & 0xFF;
    }

    public static String getName(String s) {
        String temp = null;
        while (s.indexOf("/") > -1) {
            s = s.substring(s.indexOf("/") + 1);
        }
        temp = s;
        if (temp.indexOf(".") > -1) {
            temp = temp.substring(0, temp.indexOf("."));
        }
        return temp;
    }

    public static byte[] randomByte() {
        String temp = null;
        temp = Long.toString(System.currentTimeMillis(), 16) + Integer.toString(new Random().nextInt(100000) + 100000, 16);
        return ByteTools.hexStr2byteArr(temp);
    }

    public static byte[] cip2bytes(String ip) {
        byte[] temp = new byte[4];
        String temps = null;
        int tempi = 0;
        byte[] tempb = new byte[4];
        for (int i = 0; i < 4; ++i) {
            if (i != 3) {
                temps = ip.substring(0, ip.indexOf("."));
                ip = ip.substring(ip.indexOf(".") + 1);
                tempi = Integer.parseInt(temps);
                tempb = ByteTools.int2bytes(tempi);
                System.arraycopy(tempb, 3, temp, i, 1);
                continue;
            }
            tempi = Integer.parseInt(ip);
            tempb = ByteTools.int2bytes(tempi);
            System.arraycopy(tempb, 3, temp, i, 1);
        }
        return temp;
    }

    public static byte[] ip2bytes(String ip) {
        byte[] temp = new byte[4];
        String temps = null;
        int tempi = 0;
        byte[] tempb = new byte[4];
        for (int i = 0; i < 4; ++i) {
            if (i != 3) {
                temps = ip.substring(0, ip.indexOf("."));
                ip = ip.substring(ip.indexOf(".") + 1);
                tempi = Integer.parseInt(temps);
                tempb = ByteTools.int2bytes(tempi);
                System.arraycopy(tempb, 3, temp, 3 - i, 1);
                continue;
            }
            tempi = Integer.parseInt(ip);
            tempb = ByteTools.int2bytes(tempi);
            System.arraycopy(tempb, 3, temp, 3 - i, 1);
        }
        return temp;
    }

    public static String bytes2ip(byte[] packet) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(packet[0] & 0xFF));
        sb.append(".");
        sb.append(Integer.toString(packet[1] & 0xFF));
        sb.append(".");
        sb.append(Integer.toString(packet[2] & 0xFF));
        sb.append(".");
        sb.append(Integer.toString(packet[3] & 0xFF));
        return sb.toString();
    }

    public static byte[] hexStr2byteArr(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            String item = new String(achar, i * 2, 2);
            result[i] = (byte)Integer.parseInt(item, 16);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean string2File(String res, String filePath) {
        boolean flag = true;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            int len;
            File distFile = new File(filePath);
            if (!distFile.getParentFile().exists()) {
                distFile.getParentFile().mkdirs();
            }
            bufferedReader = new BufferedReader(new StringReader(res));
            bufferedWriter = new BufferedWriter(new FileWriter(distFile));
            char[] buf = new char[1024];
            while ((len = bufferedReader.read(buf)) != -1) {
                bufferedWriter.write(buf, 0, len);
            }
            bufferedWriter.flush();
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = flag = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static String Bytes2HexString(byte[] b) {
        StringBuilder ret = new StringBuilder("");
        for (int i = 0; i < b.length; ++i) {
            Object hex = Integer.toHexString(b[i] & 0xFF);
            if (((String)hex).length() == 1) {
                hex = Digit[0] + (String)hex;
            }
            ret.append(((String)hex).toUpperCase());
        }
        return ret.toString();
    }

    public static int hBytesToInt(byte[] b) {
        int s = 0;
        for (int i = 0; i < 3; ++i) {
            s = b[i] >= 0 ? (s += b[i]) : s + 256 + b[i];
            s *= 256;
        }
        s = b[3] >= 0 ? (s += b[3]) : s + 256 + b[3];
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long StringToLong(String ip) {
        long lip = 0L;
        String temp = null;
        if (ip == null) return lip;
        if (!ByteTools.isIPv4(ip)) return lip;
        if (ip.indexOf(".") <= -1) return lip;
        temp = ip.substring(0, ip.indexOf("."));
        ip = ip.substring(ip.indexOf(".") + 1);
        lip += Long.parseLong(temp) * 1000000000L;
        if (ip.indexOf(".") <= -1) return 0L;
        temp = ip.substring(0, ip.indexOf("."));
        ip = ip.substring(ip.indexOf(".") + 1);
        lip += Long.parseLong(temp) * 1000000L;
        if (ip.indexOf(".") <= -1) return 0L;
        temp = ip.substring(0, ip.indexOf("."));
        ip = ip.substring(ip.indexOf(".") + 1);
        return lip + Long.parseLong(temp) * 1000L + Long.parseLong(ip);
    }

    public static boolean isIPv4(String value) {
        if (value == null) {
            return false;
        }
        String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        return value.matches(ip);
    }

    public static String LongToString(long lip) {
        Object ip = "";
        long temp = 0L;
        temp = lip / 1000L;
        ip = String.valueOf(lip % 1000L);
        lip = temp / 1000L;
        ip = String.valueOf(temp % 1000L) + "." + (String)ip;
        temp = lip / 1000L;
        ip = String.valueOf(lip % 1000L) + "." + (String)ip;
        lip = temp / 1000L;
        ip = String.valueOf(temp % 1000L) + "." + (String)ip;
        return ip;
    }

    public static long getID() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Random random = new Random();
        String id = df.format(new Date(System.currentTimeMillis())) + random.nextInt(1000);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Long.parseLong(id);
    }

    public static String isIdentifier(String identifier) {
        String[] Errors = new String[]{"yes", "\u8eab\u4efd\u8bc1\u53f7\u7801\u4f4d\u6570\u4e0d\u5bf9!", "\u8eab\u4efd\u8bc1\u53f7\u7801\u51fa\u751f\u65e5\u671f\u8d85\u51fa\u8303\u56f4\u6216\u542b\u6709\u975e\u6cd5\u5b57\u7b26!", "\u8eab\u4efd\u8bc1\u53f7\u7801\u6821\u9a8c\u9519\u8bef!", "\u8eab\u4efd\u8bc1\u5730\u533a\u975e\u6cd5!"};
        HashMap<String, String> area = new HashMap<String, String>();
        area.put("11", "\u5317\u4eac");
        area.put("12", "\u5929\u6d25");
        area.put("13", "\u6cb3\u5317");
        area.put("14", "\u5c71\u897f");
        area.put("15", "\u5185\u8499\u53e4");
        area.put("21", "\u8fbd\u5b81");
        area.put("22", "\u5409\u6797");
        area.put("23", "\u9ed1\u9f99\u6c5f");
        area.put("31", "\u4e0a\u6d77");
        area.put("32", "\u6c5f\u82cf");
        area.put("33", "\u6d59\u6c5f");
        area.put("34", "\u5b89\u5fbd");
        area.put("35", "\u798f\u5efa");
        area.put("36", "\u6c5f\u897f");
        area.put("37", "\u5c71\u4e1c");
        area.put("41", "\u6cb3\u5357");
        area.put("42", "\u6e56\u5317");
        area.put("43", "\u6e56\u5357");
        area.put("44", "\u5e7f\u4e1c");
        area.put("45", "\u5e7f\u897f");
        area.put("46", "\u6d77\u5357");
        area.put("50", "\u91cd\u5e86");
        area.put("51", "\u56db\u5ddd");
        area.put("52", "\u8d35\u5dde");
        area.put("53", "\u4e91\u5357");
        area.put("54", "\u897f\u85cf");
        area.put("61", "\u9655\u897f");
        area.put("62", "\u7518\u8083");
        area.put("63", "\u9752\u6d77");
        area.put("64", "\u5b81\u590f");
        area.put("65", "\u65b0\u7586");
        area.put("71", "\u53f0\u6e7e");
        area.put("81", "\u9999\u6e2f");
        area.put("81", "\u9999\u6e2f");
        area.put("82", "\u6fb3\u95e8");
        area.put("91", "\u56fd\u5916");
        identifier = identifier.trim();
        if (identifier.length() < 15) {
            return Errors[1];
        }
        if (area.get(identifier.substring(0, 2)) == null) {
            return Errors[4];
        }
        switch (identifier.length()) {
            case 15: {
                String ereg = (Integer.parseInt(identifier.substring(6, 8)) + 1900) % 4 == 0 || (Integer.parseInt(identifier.substring(6, 8)) + 1900) % 100 == 0 && (Integer.parseInt(identifier.substring(6, 8)) + 1900) % 4 == 0 ? "^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}$" : "^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}$";
                Pattern pattern = Pattern.compile(ereg);
                Matcher matcher = pattern.matcher(identifier);
                if (matcher.matches()) {
                    return Errors[0];
                }
                return Errors[2];
            }
            case 18: {
                String ereg = Integer.parseInt(identifier.substring(6, 8)) % 4 == 0 || Integer.parseInt(identifier.substring(6, 8)) % 100 == 0 && Integer.parseInt(identifier.substring(6, 8)) % 4 == 0 ? "^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$" : "^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$";
                Pattern pattern = Pattern.compile(ereg);
                Matcher matcher = pattern.matcher(identifier);
                if (matcher.matches()) {
                    int S = (Integer.parseInt(identifier.substring(0, 1)) + Integer.parseInt(identifier.substring(10, 11))) * 7 + (Integer.parseInt(identifier.substring(1, 2)) + Integer.parseInt(identifier.substring(11, 12))) * 9 + (Integer.parseInt(identifier.substring(2, 3)) + Integer.parseInt(identifier.substring(12, 13))) * 10 + (Integer.parseInt(identifier.substring(3, 4)) + Integer.parseInt(identifier.substring(13, 14))) * 5 + (Integer.parseInt(identifier.substring(4, 5)) + Integer.parseInt(identifier.substring(14, 15))) * 8 + (Integer.parseInt(identifier.substring(5, 6)) + Integer.parseInt(identifier.substring(15, 16))) * 4 + (Integer.parseInt(identifier.substring(6, 7)) + Integer.parseInt(identifier.substring(16, 17))) * 2 + Integer.parseInt(identifier.substring(7, 8)) * 1 + Integer.parseInt(identifier.substring(8, 9)) * 6 + Integer.parseInt(identifier.substring(9, 10)) * 3;
                    int Y = S % 11;
                    String M = "F";
                    String JYM = "10X98765432";
                    M = JYM.substring(Y, Y + 1);
                    if (M.equals(identifier.substring(17, 18))) {
                        return Errors[0];
                    }
                    return Errors[3];
                }
                return Errors[2];
            }
        }
        return Errors[1];
    }
}

