/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.utils.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateObject {
    private static final DateFormat whippletreeTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MIDDLE_LINE = "-";
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int dateValue = 0;
    private int yearDate = 0;

    public int getYearDate() {
        return this.yearDate;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getDateValue() {
        return this.dateValue;
    }

    public DateObject(String timestamp) {
        if (StringUtils.isEmpty(timestamp)) {
            throw new IllegalArgumentException("\u63a5\u6536\u5230\u65f6\u95f4\u6570\u636e\u4e0d\u5b58\u5728(timestamp is null)");
        }
        this.dateValue = Integer.parseInt(timestamp.substring(0, 10).replaceAll(MIDDLE_LINE, ""));
        this.year = this.dateValue / 10000;
        this.month = this.dateValue / 100 - this.year * 100;
        this.yearDate = this.dateValue / 100;
        this.day = this.dateValue % this.yearDate;
    }

    public DateObject() {
        this(whippletreeTimeFormat.format(new Date(System.currentTimeMillis())));
    }

    public DateObject(int dateValue) {
        if (dateValue <= 0) {
            throw new IllegalArgumentException("dateValue must >= 0, eg. 20181225");
        }
        this.dateValue = dateValue;
        this.year = dateValue / 10000;
        this.month = dateValue / 100 - this.year * 100;
        this.yearDate = dateValue / 100;
        this.day = dateValue % this.yearDate;
    }

    public String toString() {
        return "[ year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", dateValue=" + this.dateValue + ", yearDate=" + this.yearDate + "]";
    }

    public static void main(String[] args) {
    }
}

