/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.core.NestedRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static final String OS_NAME = "os.name";
    public static final String OS_WINDOWS_NAME = "windows";
    public static final String FILE_SEPARATOR = "/";
    public static final String THUMB_SUFFIX = "_s";
    private static final String FILE_ROOT_WINDOWS = "";
    private static final String FILE_ROOT_UNIX = "/";
    private static final String FILE_EXT_SEPARATOR = ".";

    public static final String getFileNameWithoutSuffix(String videoPath, String suffix) {
        String[] array = (videoPath = videoPath.replaceAll("\\\\", "/")).split("/");
        if (array == null || array.length == 0) {
            System.out.println("\u6587\u4ef6\u540d\u79f0\u622a\u53d6id\u9519\u8bef:" + videoPath);
            return null;
        }
        String fileName = array[array.length - 1];
        return fileName.replaceAll(suffix, FILE_ROOT_WINDOWS);
    }

    public static final String getFilePathWithoutName(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        int lastSeparatorIndex = url.lastIndexOf("/");
        if (lastSeparatorIndex < 0) {
            System.out.println("url\u4e2d\u4e0d\u5305\u542b\u6587\u4ef6\u8def\u5f84:" + url);
            return null;
        }
        return url.substring(0, lastSeparatorIndex);
    }

    public static final String getFileNameWithoutPath(String url) {
        int fileNameIndex = url.lastIndexOf("/") + 1;
        if (fileNameIndex < 0) {
            System.out.println("url\u4e2d\u4e0d\u5305\u542b\u6587\u4ef6\u8def\u5f84:" + url);
            return null;
        }
        return url.substring(fileNameIndex, url.length());
    }

    public static final boolean isExist(String fileOrFolder) {
        if (StringUtils.isEmpty(fileOrFolder)) {
            return false;
        }
        File file = new File(fileOrFolder);
        return file.exists();
    }

    public static final boolean isWindows() {
        String osName = System.getProperty(OS_NAME);
        return osName != null && osName.toLowerCase().indexOf(OS_WINDOWS_NAME) >= 0;
    }

    public static final String getFileSystemRoot() {
        if (FileUtils.isWindows()) {
            return FILE_ROOT_WINDOWS;
        }
        return "/";
    }

    public static final void checkDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static final String getFileExt(String filename) {
        int extIndex = filename.lastIndexOf(FILE_EXT_SEPARATOR);
        if (extIndex > 0) {
            return filename.substring(extIndex + 1);
        }
        return null;
    }

    public static final byte[] getFileBytes(File file) {
        assert (file != null);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[in.available()];
            in.read(buffer, 0, buffer.length);
            byte[] byArray = buffer;
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new com.walker.infrastructure.core.FileNotFoundException();
        }
        catch (IOException ioe) {
            throw new NestedRuntimeException(null, ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static List<String> getFileLines(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bfb\u53d6\u5185\u5bb9\uff1a" + filePath);
            return null;
        }
        ArrayList<String> content = new ArrayList<String>(64);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(read);){
            if (file.isFile() && file.exists()) {
                String lineTxt;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    content.add(lineTxt);
                }
            } else {
                System.out.println("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
        }
        return content;
    }

    public static final void writeFile(byte[] content, String filename) {
        throw new UnsupportedOperationException();
    }

    public static final boolean deleteFile(File file) {
        if (file != null) {
            try {
                if (file.isDirectory()) {
                    throw new UnsupportedOperationException("File must be not a directory!");
                }
                return file.delete();
            }
            catch (Exception e) {
                throw new NestedRuntimeException(null, e);
            }
        }
        return false;
    }

    public static boolean writeTxtFile(String content, File fileName) throws Exception {
        boolean flag = false;
        try (RandomAccessFile mm = null;){
            mm = new RandomAccessFile(fileName, "rw");
            mm.writeBytes(content);
            flag = true;
        }
        return flag;
    }

    public static final void createEmptyFile(String filepath) throws IOException {
        File file = new File(filepath);
        if (!file.exists()) {
            file.createNewFile();
        } else {
            System.out.println("file exist: " + filepath);
        }
    }

    @Deprecated
    public static final String getThumbNailsName(String path, String ext) {
        StringBuilder thumb = new StringBuilder();
        thumb.append(path.subSequence(0, path.lastIndexOf(FILE_EXT_SEPARATOR)));
        thumb.append("_s.").append(ext);
        return thumb.toString();
    }

    public static final String getThumbNailsName(String path) {
        StringBuilder thumb = new StringBuilder();
        thumb.append(path.subSequence(0, path.lastIndexOf(FILE_EXT_SEPARATOR)));
        thumb.append("_s.").append(FileUtils.getFileExt(path));
        return thumb.toString();
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.getFilePathWithoutName("d:/test/demo.jpg"));
        System.out.println(FileUtils.getFileNameWithoutPath("d:/test/demo.jpg"));
    }
}

