/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.FileUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ImageUtils.class);
    public static final String IMAGE_JPG = "jpg";

    public static String scaleImage4Jpg(String sourceImagePath, double maxWidth) {
        int height;
        int width;
        BufferedImage bufferedImage;
        block5: {
            File file = new File(sourceImagePath);
            bufferedImage = null;
            bufferedImage = ImageIO.read(file);
            width = bufferedImage.getWidth();
            height = bufferedImage.getHeight();
            if (!((double)width <= maxWidth)) break block5;
            String string = sourceImagePath;
            return string;
        }
        try {
            double scale = maxWidth / (double)width;
            logger.debug("scale = {}", (Object)scale);
            width = ImageUtils.parseDoubleToInt((double)width * scale);
            height = ImageUtils.parseDoubleToInt((double)height * scale);
            Image image = bufferedImage.getScaledInstance(width, height, 4);
            BufferedImage outputImage = new BufferedImage(width, height, 1);
            Graphics graphics = outputImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            String destinationPath = FileUtils.getThumbNailsName(sourceImagePath);
            ImageIO.write((RenderedImage)outputImage, IMAGE_JPG, new File(destinationPath));
            String string = destinationPath;
            return string;
        }
        catch (IOException e) {
            logger.error("scaleImage\u65b9\u6cd5\u538b\u7f29\u56fe\u7247\u65f6\u51fa\u9519:" + e.getMessage() + ", file=" + sourceImagePath, (Throwable)e);
            throw new ApplicationRuntimeException("\u538b\u7f29\u56fe\u7247\u9519\u8bef\uff1a" + sourceImagePath, e);
        }
    }

    private static int parseDoubleToInt(double sourceDouble) {
        boolean result = false;
        return (int)sourceDouble;
    }
}

