/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.StringUtils;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static final <T> List<T> jsonStringToList(String json, Class<T> clazz) throws Exception {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        return (List)objectMapper.readValue(json, javaType);
    }

    public static final ObjectNode javaObjectToObjectNode(Object javaObj) {
        return (ObjectNode)objectMapper.convertValue(javaObj, ObjectNode.class);
    }

    public static String objectToJsonString(Object javaObject) throws Exception {
        return objectMapper.writeValueAsString(javaObject);
    }

    public static byte[] objectToBytes(Object javaObject) throws Exception {
        if (javaObject == null) {
            return null;
        }
        return objectMapper.writeValueAsBytes(javaObject);
    }

    public static <T> T jsonStringToObject(String json, Class<T> clazz) throws Exception {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static ObjectNode jsonStringToObjectNode(String json) throws Exception {
        return JsonUtils.jsonStringToObject(json, ObjectNode.class);
    }

    public static ObjectNode mapToObjectNode(Map<String, Object> map) {
        ObjectNode node = objectMapper.createObjectNode();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                node.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return node;
    }

    public static String toJsonArray(List<ObjectNode> objectNodeList) throws Exception {
        ArrayNode arrayNode = objectMapper.createArrayNode();
        if (!StringUtils.isEmptyList(objectNodeList)) {
            for (ObjectNode on : objectNodeList) {
                arrayNode.add((JsonNode)on);
            }
        }
        return objectMapper.writeValueAsString((Object)arrayNode);
    }

    public static ArrayNode toJsonArray(String jsonArray) throws Exception {
        return (ArrayNode)objectMapper.readValue(jsonArray, ArrayNode.class);
    }

    public static final boolean isEmptyObject(JsonNode jsonNode) {
        if (jsonNode == null) {
            return true;
        }
        return jsonNode.toString().equals("null");
    }
}

