/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LongDateHelper {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat sdfDatetime = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat normalFormat = new SimpleDateFormat("yyyy-MM-dd");

    public long setDay(long longDate, long longDay) {
        long currMonthLastDay;
        int lastDay;
        Calendar calendar = Calendar.getInstance();
        int intDay = (int)longDay;
        long longNewDate = 0L;
        String strDate = String.valueOf(longDate);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6));
        if (intDay > 28 && intDay > (lastDay = Integer.parseInt(String.valueOf(currMonthLastDay = LongDateHelper.getMonthLastDay(longDate, 1)).substring(6, 8)))) {
            intDay = lastDay;
        }
        calendar.set(year, month - 1, intDay);
        longNewDate = Long.parseLong(sdf.format(calendar.getTime()));
        return longNewDate;
    }

    public static long getMonthFirstDay(long longDate, int flag) {
        Calendar calendar = Calendar.getInstance();
        long longNewDate = 0L;
        String strDate = String.valueOf(longDate);
        if (flag < 0 || flag > 1) {
            flag = 1;
        }
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - flag;
        int day = 1;
        calendar.set(year, month, day);
        longNewDate = Long.parseLong(sdf.format(calendar.getTime()));
        return longNewDate;
    }

    public static long getLastDayOfMonth() {
        Calendar lastDate = Calendar.getInstance();
        lastDate.set(5, 1);
        lastDate.add(2, 1);
        lastDate.add(5, -1);
        return Long.parseLong(sdf.format(lastDate.getTime()));
    }

    public static String getFirstDayOfMonth() {
        return normalFormat.format(LongDateHelper.getFirstDateOfMonth());
    }

    public static Date getFirstDateOfMonth() {
        Calendar lastDate = Calendar.getInstance();
        lastDate.set(5, 1);
        return lastDate.getTime();
    }

    public static long getFirstDayOfPremonth() {
        Calendar lastDate = Calendar.getInstance();
        lastDate.set(5, 1);
        lastDate.add(2, -1);
        return Long.parseLong(sdf.format(lastDate.getTime()));
    }

    public static long getLastDayOfPremonth() {
        Calendar lastDate = Calendar.getInstance();
        lastDate.set(5, 1);
        lastDate.add(5, -1);
        return Long.parseLong(sdf.format(lastDate.getTime()));
    }

    @Deprecated
    public static long getMonthLastDay(long longDate, int flag) {
        long longNewDate = 0L;
        if (flag < 0 || flag > 1) {
            flag = 1;
        }
        long longNextMonthFirstDay = LongDateHelper.getMonthFirstDay(longDate, flag);
        long longDayTime = 86400000L;
        long longTime = LongDateHelper.getTimeOfDate(longNextMonthFirstDay);
        Date newDate = new Date(longTime - longDayTime);
        longNewDate = Long.parseLong(sdf.format(newDate));
        return longNewDate;
    }

    public static long getTimeOfDate(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        long longTimes = 0L;
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        longTimes = calendar.getTime().getTime();
        return longTimes;
    }

    public long getTransDate(long date, int rate, int flag) {
        int year = Integer.parseInt(String.valueOf(date).substring(0, 4));
        int month = Integer.parseInt(String.valueOf(date).substring(4, 6)) - 1;
        int day = Integer.parseInt(String.valueOf(date).substring(6, 8));
        int newYear = 0;
        int newMonth = 0;
        int newDay = 0;
        if (flag == 0) {
            newYear = year + rate;
            newMonth = month;
            newDay = day;
        } else if (flag == 1) {
            newMonth = month + rate;
            newYear = year;
            newDay = day;
        } else {
            newDay = day + rate;
            newYear = year;
            newMonth = month;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(newYear, newMonth, newDay);
        Date now = calendar.getTime();
        return Long.parseLong(sdf.format(now));
    }

    public static long addSeconds(long old, long seconds) {
        long year = old / 10000000000L;
        long month = (old - year * 10000000000L) / 100000000L;
        long day = (old - year * 10000000000L - month * 100000000L) / 1000000L;
        long hour = (old - year * 10000000000L - month * 100000000L - day * 1000000L) / 10000L;
        long minus = (old - year * 10000000000L - month * 100000000L - day * 1000000L - hour * 10000L) / 100L;
        long second = old - year * 10000000000L - month * 100000000L - day * 1000000L - hour * 10000L - minus * 100L;
        Calendar cl = Calendar.getInstance();
        cl.set((int)year, (int)month - 1, (int)day, (int)hour, (int)minus, (int)second);
        Date date = new Date(cl.getTime().getTime() + seconds * 1000L);
        String sdate = sdfDatetime.format(date);
        return Long.parseLong(sdate);
    }

    public static long secondsBetween(long begin, long end) throws Exception {
        String strBegin = "" + begin;
        String strEnd = "" + end;
        if (strBegin.length() != 14 || strEnd.length() != 14) {
            throw new Exception("\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9,\u5fc5\u987b\u4f7f\u752814\u4f4d\u7684\u65f6\u95f4\u683c\u5f0f");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(strBegin.substring(0, 4)), Integer.parseInt(strBegin.substring(4, 6)) - 1, Integer.parseInt(strBegin.substring(6, 8)), Integer.parseInt(strBegin.substring(8, 10)), Integer.parseInt(strBegin.substring(10, 12)), Integer.parseInt(strBegin.substring(12, 14)));
        long longBegin = calendar.getTimeInMillis();
        calendar.set(Integer.parseInt(strEnd.substring(0, 4)), Integer.parseInt(strEnd.substring(4, 6)) - 1, Integer.parseInt(strEnd.substring(6, 8)), Integer.parseInt(strEnd.substring(8, 10)), Integer.parseInt(strEnd.substring(10, 12)), Integer.parseInt(strEnd.substring(12, 14)));
        long longEnd = calendar.getTimeInMillis();
        return (longEnd - longBegin) / 1000L;
    }

    public static long getDaysBetween(long begin, long end) throws Exception {
        long returnValue = 0L;
        String strBegin = String.valueOf(begin);
        String strEnd = String.valueOf(end);
        if (strBegin.length() != 8) {
            throw new RuntimeException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int yearBegin = Integer.parseInt(strBegin.substring(0, 4), 10);
        int monthBegin = Integer.parseInt(strBegin.substring(4, 6), 10);
        int dayBegin = Integer.parseInt(strBegin.substring(6, 8), 10);
        int yearEnd = Integer.parseInt(strEnd.substring(0, 4), 10);
        int monthEnd = Integer.parseInt(strEnd.substring(4, 6), 10);
        int dayEnd = Integer.parseInt(strEnd.substring(6, 8), 10);
        Calendar calendar = Calendar.getInstance();
        calendar.set(yearBegin, monthBegin - 1, dayBegin);
        long milliSecondsBegin = calendar.getTime().getTime();
        calendar.set(yearEnd, monthEnd - 1, dayEnd);
        long milliSecondsEnd = calendar.getTime().getTime();
        returnValue = (milliSecondsEnd - milliSecondsBegin) / 86400000L;
        return returnValue;
    }

    public static long getAfterLongTime(long oldTime, int dayNum) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(oldTime);
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        int hour = Integer.parseInt(strDate.substring(8, 9));
        int minute = Integer.parseInt(strDate.substring(9, 10));
        int second = Integer.parseInt(strDate.substring(10, 11));
        calendar.set(year, month, day, hour, minute, second);
        calendar.add(5, dayNum);
        String result = sdfDatetime.format(calendar.getTime());
        return Long.parseLong(result);
    }

    public static void main(String[] s) {
        try {
            System.out.println(LongDateHelper.getDaysBetween(20041101L, 20041202L));
            System.out.println("---------" + LongDateHelper.getAfterLongTime(20071205121212L, -1));
            System.out.println(LongDateHelper.getFirstDayOfPremonth());
            System.out.println(LongDateHelper.getLastDayOfMonth());
            System.out.println(LongDateHelper.getFirstDayOfMonth());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

