/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class MD5 {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String MD5_NAME = "MD5";
    public static final String NAME_SIGN_2 = "sign";
    private static final String NAME_SIGN_TYPE = "sign_type";

    public static String encryption(String plainText) {
        String re_md5 = "";
        try {
            MessageDigest md = MessageDigest.getInstance(MD5_NAME);
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuilder buf = new StringBuilder("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            re_md5 = buf.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u672a\u627e\u5230MD5\u7b97\u6cd5\uff1a" + e.getMessage(), e);
        }
        return re_md5;
    }

    public static String sign(String text, String key, String input_charset) {
        text = (String)text + key;
        return DigestUtils.md5Hex((byte[])MD5.getContentBytes((String)text, input_charset));
    }

    public static boolean verify(String text, String sign, String key, String input_charset) {
        String mysign = DigestUtils.md5Hex((byte[])MD5.getContentBytes((String)(text = (String)text + key), input_charset));
        return mysign.equals(sign);
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static final String getMessageDigest(byte[] buffer) {
        try {
            MessageDigest mdTemp = MessageDigest.getInstance(MD5_NAME);
            mdTemp.update(buffer);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String signJson(String json, String key) {
        if (json == null) {
            return null;
        }
        try {
            Map map = JsonUtils.jsonStringToObject(json, Map.class);
            Map<String, String> sParaNew = MD5.paraFilter(map);
            String preSignStr = MD5.createLinkString(sParaNew);
            return MD5.sign(preSignStr, key, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String signJsonFast(String json, String key) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        return MD5.sign(json, key, "UTF-8");
    }

    @Deprecated
    public static boolean verifyJson(String json, String sign, String md5Key) {
        if (StringUtils.isEmpty(json)) {
            return false;
        }
        try {
            Map map = JsonUtils.jsonStringToObject(json, Map.class);
            return MD5.getMd5SignVeryfy(map, sign, md5Key);
        }
        catch (Exception e) {
            throw new RuntimeException("verifyJson:\u8f6c\u6362json\u5b57\u7b26\u4e32\u4e3aMap\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    public static boolean verifyJsonFast(String json, String sign, String md5Key) {
        if (json == null) {
            return false;
        }
        try {
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode(json);
            objectNode.remove(NAME_SIGN_2);
            return MD5.verify(JsonUtils.objectToJsonString(objectNode), sign, md5Key, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("verifyJsonFast:\u8f6c\u6362json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    public static boolean getMd5SignVeryfy(Map<String, Object> Params, String sign, String md5Key) {
        Map<String, String> sParaNew = MD5.paraFilter(Params);
        String preSignStr = MD5.createLinkString(sParaNew);
        return MD5.verify(preSignStr, sign, md5Key, "UTF-8");
    }

    private static Map<String, String> paraFilter(Map<String, Object> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        String value = null;
        for (String key : sArray.keySet()) {
            value = sArray.get(key).toString();
            if (StringUtils.isEmpty(value) || key.equalsIgnoreCase(NAME_SIGN_2) || key.equalsIgnoreCase(NAME_SIGN_TYPE)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder result = new StringBuilder();
        String key = null;
        String value = null;
        for (int i = 0; i < keys.size(); ++i) {
            key = (String)keys.get(i);
            value = params.get(key);
            if (i > 0) {
                result.append("&");
            }
            result.append(key).append("=").append(value);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(MD5.encryption("123456"));
    }
}

