/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.ServerId;
import com.walker.infrastructure.utils.StringUtils;
import java.util.UUID;

public abstract class NumberGenerator {
    public static final long[] DIGIT_SIZE_TABLE = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L};
    public static final int NANO_SIZE = 16;

    public static final long getLongSequenceNumberNano() {
        long id;
        int idSize;
        long nano = System.nanoTime();
        if (nano < 0L) {
            nano = Math.abs(nano);
        }
        if ((idSize = NumberGenerator.getDigitBitSize(id = System.currentTimeMillis() + nano)) > 16) {
            id = System.currentTimeMillis() * 1000L + Long.parseLong(StringUtils.generateRandomNumber(3));
        }
        return id;
    }

    private static final int getDigitBitSize(long value) {
        int i = 0;
        while (value > DIGIT_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static final long getSequenceNumber() {
        return System.currentTimeMillis();
    }

    public static final long getLongSequenceNumber() {
        return NumberGenerator.getLongSequenceNumberNano();
    }

    public static final String getLongSequenceId() {
        return ServerId.getId() + "_" + NumberGenerator.getLongSequenceNumber() + "_" + StringUtils.generateRandomNumber(5);
    }

    public static String generatorHexUUID() {
        return UUID.randomUUID().toString();
    }

    public static void main(String[] args) {
        long startTime = 0L;
        long nanoSecond = 0L;
        for (int i = 0; i < 30; ++i) {
            startTime = System.nanoTime();
            nanoSecond = NumberGenerator.getLongSequenceNumberNano();
            System.out.println(nanoSecond + ", total time = " + (System.nanoTime() - startTime));
        }
        long mod = System.nanoTime() % 10L;
        System.out.println(mod);
    }
}

