/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.utils.StringUtils;

public class PasswordUtils {
    public static final int LEVEL_01_LOW = 1;
    public static final int LEVEL_02_MEDIUM = 2;
    public static final int LEVEL_03_HIGH = 3;
    public static final int LEVEL_04_VERY_HIGH = 4;
    public static final String REGEX_ONLY_LOW_CASE = "[a-z]";
    public static final String REGEX_ONLY_UPPER_CASE = "[A-Z]";
    public static final String REGEX_ONLY_DIGIT = "[0-9]";
    public static final String REGEX_ONLY_SPECIAL_CHAR = "[0-9,A-Z,a-z]";

    public static final String filterText(String text) {
        if (StringUtils.isEmpty(text)) {
            return "\u8bf7\u8bbe\u7f6e\u8fc7\u6ee4\u5b57\u7b26\u4e32";
        }
        char c = '\u0000';
        for (int i = 0; i < text.length(); ++i) {
            c = text.charAt(i);
            if (c == ' ') {
                return "\u4e0d\u80fd\u5b58\u5728\u7a7a\u683c";
            }
            if (c == '*') {
                return "\u4e0d\u80fd\u5b58\u5728*";
            }
            if (c == '<' || c == '>') {
                return "\u4e0d\u80fd\u5b58\u5728\u5c16\u62ec\u53f7";
            }
            if (c >= '[' && c <= ']') {
                return "\u4e0d\u80fd\u5b58\u5728[\\]\u7b26\u53f7";
            }
            if (c == '/') {
                return "\u4e0d\u80fd\u5b58\u5728\u659c\u6760";
            }
            if (c == '~' || c >= '!' && c <= 'z') continue;
            return "\u4e0d\u652f\u6301\u7684\u7b26\u53f7:" + c;
        }
        return null;
    }

    public static final boolean validateComplex(String password, int level) {
        if (level == 1) {
            return PasswordUtils.isConditionRule(password, REGEX_ONLY_LOW_CASE) || PasswordUtils.isConditionRule(password, REGEX_ONLY_DIGIT);
        }
        if (level == 2) {
            return PasswordUtils.isConditionRule(password, REGEX_ONLY_LOW_CASE) && PasswordUtils.isConditionRule(password, REGEX_ONLY_DIGIT);
        }
        if (level == 3) {
            return PasswordUtils.isConditionRule(password, REGEX_ONLY_LOW_CASE) && PasswordUtils.isConditionRule(password, REGEX_ONLY_UPPER_CASE) && PasswordUtils.isConditionRule(password, REGEX_ONLY_DIGIT);
        }
        if (level == 4) {
            return PasswordUtils.isConditionRule(password, REGEX_ONLY_LOW_CASE) && PasswordUtils.isConditionRule(password, REGEX_ONLY_UPPER_CASE) && PasswordUtils.isConditionRule(password, REGEX_ONLY_DIGIT) && password.replaceAll(REGEX_ONLY_SPECIAL_CHAR, "").length() > 0;
        }
        return false;
    }

    private static final boolean isConditionRule(String password, String regex) {
        return password.length() - password.replaceAll(regex, "").length() > 0;
    }
}

