/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentReader {
    private boolean keyCaseSensitive = false;
    private boolean contentIncludeKey = false;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StringBuilder totalResult = new StringBuilder(512);
    private final Map<KeyExpression, List<StringBuilder>> result2 = new HashMap<KeyExpression, List<StringBuilder>>(2);
    private final List<KeyExpression> keys = new ArrayList<KeyExpression>(2);
    private final Map<String, String> startEndKeys = new HashMap<String, String>(2);
    private int maxStartKeyLength;
    private int maxEndKeyLength = 0;
    private LinkedList<Character> scanStack = new LinkedList();
    private LinkedList<String> existKeysStack = new LinkedList();
    public static final Set<Character> keyExcludedCharSet = new HashSet<Character>();
    private LinkedList<Character> keyExcludedCharStack = new LinkedList();
    public static final int RESULT_MODE_STORE = 1;
    public static final int RESULT_MODE_REMOVE = 2;
    public static final int RESULT_MODE_REPLACE = 3;
    public static final int RESULT_MODE_CALLBACK = 4;
    private char previousRead;
    private Map<String, Integer> storedKeyCounter = new HashMap<String, Integer>(2);

    public boolean isKeyCaseSensitive() {
        return this.keyCaseSensitive;
    }

    public void setKeyCaseSensitive(boolean keyCaseSensitive) {
        this.keyCaseSensitive = keyCaseSensitive;
    }

    public boolean isContentIncludeKey() {
        return this.contentIncludeKey;
    }

    public void setContentIncludeKey(boolean contentIncludeKey) {
        this.contentIncludeKey = contentIncludeKey;
    }

    public String read(String sentence) {
        assert (sentence != null && !sentence.equals(""));
        if (this.keys.size() == 0) {
            throw new IllegalStateException("keys is required.");
        }
        this.getMaxKeyLength();
        for (KeyExpression ke : this.keys) {
            this.result2.put(ke, new ArrayList());
            this.startEndKeys.put(ke.getStartKey(), ke.getEndKey());
        }
        for (Object c : (Object)(this.keyCaseSensitive ? sentence.toCharArray() : sentence.toLowerCase().toCharArray())) {
            this.readOneCharacter((char)c, false);
        }
        this.readOneCharacter(this.scanStack.peekLast().charValue(), true);
        return this.totalResult.toString();
    }

    public String getSolvedContent(String startKey, String endKey) {
        KeyExpression ke = new KeyExpression(startKey, endKey);
        List<StringBuilder> sb = this.result2.get(ke);
        return sb == null ? null : (sb.size() == 0 ? null : sb.get(0).toString());
    }

    public List<StringBuilder> getSolvedList(String startKey, String endKey) {
        return this.result2.get(new KeyExpression(startKey, endKey));
    }

    public void addKey(String startKey, String endKey) {
        this.addKey(startKey, endKey, 1, new Object[0]);
    }

    public void addRemoveKey(String startKey, String endKey) {
        this.addKey(startKey, endKey, 2, new Object[0]);
    }

    public void addReplaceKey(String startKey, String endKey, String replace) {
        this.addKey(startKey, endKey, 3, replace);
    }

    public void addCallbackKey(String startKey, String endKey, CallBack callback) {
        this.addKey(startKey, endKey, 4, callback);
    }

    private void addKey(String startKey, String endKey, int mode, Object ... others) {
        assert (startKey != null && !startKey.equals(""));
        if (!this.keyCaseSensitive) {
            startKey = startKey.toLowerCase();
            endKey = endKey == null ? null : endKey.toLowerCase();
        }
        for (KeyExpression ke : this.keys) {
            if (!ke.getStartKey().equals(startKey)) continue;
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u5f00\u59cb\u5173\u952e\u5b57\u91cd\u590d, key = " + startKey);
        }
        KeyExpression ke = new KeyExpression(startKey, endKey);
        if (mode == 3 || mode == 4) {
            if (others == null || others.length > 1) {
                throw new IllegalArgumentException("argument is required in mode 'REPLACE' and 'CALLBACK'.");
            }
            if (mode == 3) {
                if (!(others[0] instanceof String)) {
                    throw new IllegalArgumentException("argument of replace must be String.");
                }
                ke.setResultMode(3).setReplace(others[0].toString());
            }
            if (mode == 4) {
                if (!(others[0] instanceof CallBack)) {
                    throw new IllegalArgumentException("argument of callback must be CallBack.");
                }
                ke.setResultMode(4).setCallBack((CallBack)others[0]);
            }
        } else if (mode == 2) {
            ke.setResultMode(2);
        }
        this.keys.add(ke);
    }

    private void getMaxKeyLength() {
        int skSize = 0;
        int ekSize = 0;
        for (KeyExpression ke : this.keys) {
            int k1 = ke.getStartKey().length();
            if (k1 > skSize) {
                skSize = k1;
            }
            if (ke.getEndKey() == null || ke.getEndKey().length() <= ekSize) continue;
            ekSize = ke.getEndKey().length();
        }
        this.maxStartKeyLength = skSize;
        this.maxEndKeyLength = ekSize;
        this.logger.debug("maxStartKeyLength = " + this.maxStartKeyLength);
        this.logger.debug("maxEndKeyLength = " + this.maxEndKeyLength);
    }

    private void readOneCharacter(char c, boolean isLastRead) {
        if (c == ' ' && this.previousRead == ' ') {
            return;
        }
        this.checkKeyExcludedChar(c);
        String scaned = this.getScanedChars();
        this.doMatchedInScaned(scaned);
        if (!isLastRead) {
            this.scanStack.addLast(Character.valueOf(c));
            this.previousRead = c;
        } else {
            this.totalResult.append(this.getScanedChars());
        }
    }

    private boolean inExcludedCharStack() {
        return !this.keyExcludedCharStack.isEmpty();
    }

    private void checkKeyExcludedChar(char c) {
        if (keyExcludedCharSet.contains(Character.valueOf(c))) {
            Character existInStack = this.keyExcludedCharStack.peekLast();
            if (existInStack != null && c == existInStack.charValue()) {
                this.keyExcludedCharStack.pollLast();
            } else {
                this.keyExcludedCharStack.offerLast(Character.valueOf(c));
            }
        }
    }

    private boolean doMatchedInScaned(String scaned) {
        String existStartKey;
        String findStartKey = this.doMatchStartKey(scaned);
        if (findStartKey != null) {
            String savedData = null;
            String savedKey = null;
            if (!scaned.equals(findStartKey)) {
                if (findStartKey.equals("{") || findStartKey.equals("[")) {
                    savedData = this.contentIncludeKey ? scaned : scaned.replaceAll("\\\\" + findStartKey, "");
                } else {
                    String string = savedData = this.contentIncludeKey ? scaned : scaned.replaceAll(findStartKey, "");
                }
            }
            if ((savedKey = this.existKeysStack.peekLast()) != null) {
                int index = this.storedKeyCounter.get(savedKey);
                List<StringBuilder> sbs = this.result2.get(new KeyExpression(savedKey, this.startEndKeys.get(savedKey)));
                sbs.get(index).append(savedData == null ? "" : savedData);
            }
            this.existKeysStack.offerLast(findStartKey);
            this.scanStack.clear();
            return true;
        }
        String endKey = (existStartKey = this.existKeysStack.peekLast()) == null ? null : this.startEndKeys.get(existStartKey);
        String matchedEndKey = this.doMatchEndKey(scaned, existStartKey, endKey);
        if (matchedEndKey != null) {
            this.existKeysStack.pollLast();
            this.scanStack.clear();
            return true;
        }
        return false;
    }

    private String doMatchEndKey(String scaned, String startKey, String endKey) {
        int _ss = scaned.length();
        int size = 0;
        String cbCall = null;
        for (KeyExpression ke : this.keys) {
            if (ke.getEndKey() == null || !ke.getStartKey().equalsIgnoreCase(startKey) || _ss < (size = ke.getEndKey().length()) || !scaned.endsWith(ke.getEndKey()) || this.inExcludedCharStack()) continue;
            if (ke.getResultMode() == 1) {
                this.writeResult2(scaned, ke);
            } else if (ke.getResultMode() == 2) {
                if (this.contentIncludeKey) {
                    this.totalResult.append(ke.getEndKey());
                }
            } else if (ke.getResultMode() == 3) {
                this.writeResult2(ke.getReplace(), ke);
            } else if (ke.getResultMode() == 4) {
                cbCall = ke.getCallBack().afterSegment(scaned, ke.getStartKey(), ke.getEndKey());
                this.writeResult2(cbCall, ke);
            }
            return ke.getEndKey();
        }
        return null;
    }

    private String doMatchStartKey(String scaned) {
        int _ss = scaned.length();
        int size = 0;
        String startKey = null;
        String previousKey = null;
        for (KeyExpression ke : this.keys) {
            startKey = ke.getStartKey();
            size = ke.getStartKey().length();
            if (_ss < size || !scaned.endsWith(startKey) || (previousKey = this.existKeysStack.peekLast()) != null && previousKey.equals(startKey) || this.hasRemovedKeyInStack()) continue;
            if (ke.getResultMode() != 2) {
                Integer i = this.storedKeyCounter.get(startKey);
                if (i == null) {
                    i = 0;
                    this.storedKeyCounter.put(startKey, i);
                    this.logger.debug("\u5df2\u5b58\u50a8\u7684key '" + startKey + "' i=0.");
                } else {
                    i = i + 1;
                    this.storedKeyCounter.put(startKey, i);
                    this.logger.debug("\u5df2\u5b58\u50a8\u7684key '" + startKey + "' i=" + i);
                }
                List<StringBuilder> sbs = this.result2.get(new KeyExpression(startKey, this.startEndKeys.get(startKey)));
                sbs.add(i, new StringBuilder());
                this.logger.debug("key '" + startKey + "' \u521b\u5efa\u4e86\u7b2c" + i + "\u4e2aStringBuilder.");
            }
            if (this.contentIncludeKey) {
                this.totalResult.append(scaned);
            } else if (scaned.endsWith(ke.getStartKey())) {
                int indx = scaned.length() - ke.getStartKey().length();
                this.totalResult.append(scaned.substring(0, indx));
            } else {
                this.totalResult.append(scaned);
            }
            return ke.getStartKey();
        }
        return null;
    }

    private void writeResult2(String scaned, KeyExpression ke) {
        this.writeResult2(scaned, ke, true);
    }

    private void writeResult2(String scaned, KeyExpression ke, boolean includeTotalResult) {
        int index = this.storedKeyCounter.get(ke.getStartKey());
        if (this.contentIncludeKey) {
            this.result2.get(ke).get(index).append(scaned);
            if (includeTotalResult) {
                this.totalResult.append(scaned);
            }
        } else {
            int eIndx = scaned.length() - ke.getEndKey().length();
            this.result2.get(ke).get(index).append(scaned.substring(0, eIndx));
            if (includeTotalResult) {
                this.totalResult.append(scaned.substring(0, eIndx));
            }
        }
    }

    private boolean hasRemovedKeyInStack() {
        String _existKey = this.existKeysStack.peekLast();
        if (_existKey == null) {
            return false;
        }
        KeyExpression _k = new KeyExpression(_existKey, this.startEndKeys.get(_existKey));
        for (KeyExpression ke : this.keys) {
            if (!ke.equals(_k) || ke.getResultMode() != 2) continue;
            return true;
        }
        return false;
    }

    private String getScanedChars() {
        StringBuilder sb = new StringBuilder(8);
        Iterator iterator = this.scanStack.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            sb.append(c);
        }
        return sb.toString();
    }

    void print() {
        System.out.println("previousRead = " + this.previousRead);
        System.out.println("scanStack = " + this.scanStack.toArray());
        Iterator iterator = this.scanStack.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            System.out.print(c);
        }
    }

    public static void main(String[] args) {
        StringBuilder test = new StringBuilder();
        test.append("OPEN out_cursor FOR\r\n");
        test.append("--\u67e5\u8be2\u7535\u5b50\u94b1\u5305\u6d88\u8d39\u548c\u6708\u7968\u6d88\u8d39\r\n");
        test.append("SELECT cardtype,\r\n");
        test.append("NVL (SUM (operno), 0) AS operno,\r\n");
        test.append("NVL (SUM (viceopermn), 0) AS viceopermn\r\n");
        test.append("to_char('sum',10,90) end");
        test.append("FROM (                              --\u7535\u5b50\u94b1\u5305\u548c\u6708\u7968\u94b1\u5305\r\n");
        test.append("select * FROM TABLE t WHERE opdt >= TO_DATE(prmsdate, 'YYYY-MM-DD HH24:MI;SS'));");
        test.append("ELSE \r\n");
        test.append("OPEN out_cursor FOR querysql;\r\n");
        System.out.println(test);
        System.out.println("--------- start... ---------");
        SegmentReader sr2 = new SegmentReader();
        sr2.setKeyCaseSensitive(true);
        sr2.addKey("OPEN out_cursor FOR", ";");
        sr2.addRemoveKey("--", "\r\n");
        sr2.addKey("to_char", "end");
        System.out.println(sr2.read(test.toString()));
        System.out.println("------------------");
        System.out.println(sr2.getSolvedList("OPEN out_cursor FOR", ";"));
        System.out.println("##########");
        System.out.println(sr2.getSolvedContent("to_char", "end"));
        String srcSql = "select * from s_user_core where id = {uid}";
        SegmentReader sr = new SegmentReader();
        sr.addKey("{", "}");
        System.out.println(sr.read(srcSql));
        List<StringBuilder> paramList = sr.getSolvedList("{", "}");
        System.out.println(paramList);
    }

    static {
        keyExcludedCharSet.add(Character.valueOf('\''));
    }

    private class KeyExpression {
        private String startKey;
        private String endKey;
        private int resultMode = 1;
        private CallBack callBack;
        private String replace;

        public KeyExpression(String startKey, String endKey) {
            assert (startKey != null && !startKey.equals(""));
            if (!SegmentReader.this.keyCaseSensitive) {
                this.startKey = startKey.toLowerCase();
                this.endKey = endKey == null ? null : endKey.toLowerCase();
            } else {
                this.startKey = startKey;
                this.endKey = endKey;
            }
        }

        public String getStartKey() {
            return this.startKey;
        }

        public String getEndKey() {
            return this.endKey;
        }

        public String getReplace() {
            return this.replace;
        }

        public CallBack getCallBack() {
            return this.callBack;
        }

        public int getResultMode() {
            return this.resultMode;
        }

        public KeyExpression setResultMode(int mode) {
            this.resultMode = mode;
            return this;
        }

        public KeyExpression setReplace(String replace) {
            this.replace = replace;
            return this;
        }

        public KeyExpression setCallBack(CallBack callback) {
            this.callBack = callback;
            return this;
        }

        public int hashCode() {
            return 31 + 13 * this.startKey.hashCode() + (this.endKey == null ? 0 : this.endKey.hashCode() * 13);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof KeyExpression) {
                KeyExpression ke = (KeyExpression)o;
                if (ke == this) {
                    return true;
                }
                if (ke.startKey.equals(this.startKey)) {
                    return ke.endKey == null ? this.endKey == null : this.endKey != null && this.endKey.equals(ke.endKey);
                }
            }
            return false;
        }

        public String toString() {
            return "{skey=" + this.startKey + ", ekey=" + this.endKey + ", mode=" + this.resultMode + ", replace=" + this.replace + ", callback=" + (this.callBack == null ? "" : this.callBack.getClass().getName()) + "}";
        }
    }

    protected static interface CallBack {
        public String afterSegment(String var1, String var2, String var3);
    }
}

