/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class UrlUtils {
    public static String decode(String url) {
        return UrlUtils.decode(url, "UTF-8");
    }

    public static String decode(String content, Charset charset) {
        if (null == charset) {
            charset = UrlUtils.defaultCharset();
        }
        return UrlUtils.decode(content, charset.name());
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    public static final String decode(String url, String charset) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decode\u9519\u8bef\uff0c\u5b57\u7b26\u96c6\u4e0d\u652f\u6301\uff1a" + charset, e);
        }
    }
}

