/*
 * Decompiled with CFR 0.152.
 */
package com.walker.infrastructure.utils;

import com.walker.infrastructure.utils.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public abstract class WaitConsoleInput {
    public static final String DEFAULT_TERMINATOR = "exit";

    private WaitConsoleInput() {
    }

    public static final void waitInput() {
        WaitConsoleInput.waitInput(null);
    }

    public static final void waitInput(InputCallback callback) {
        WaitConsoleInput.waitInput(DEFAULT_TERMINATOR, callback);
    }

    public static final void waitInput(String terminator, InputCallback callback) {
        Assert.notNull(terminator, "terminator is required! e.g. exit");
        System.out.println("info:/> Please input something... '" + terminator + "' for terminate.");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String input;
            while ((input = reader.readLine()) != null) {
                if (input.trim().toLowerCase().equals(terminator.trim().toLowerCase())) {
                    System.out.println("info:/> System Exit!");
                    break;
                }
                if (callback != null) {
                    System.out.println("info:/> execute callback: " + callback);
                    callback.doInput(input);
                } else {
                    System.out.println("info:/> you input: " + input);
                }
                System.out.print("\r");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Error("System error internal, terminated!");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final void waitInTimes(TimeUnit timeUnit, long timeout) {
        try {
            timeUnit.sleep(timeout);
        }
        catch (InterruptedException e) {
            System.out.println("Thread Interrupted: " + e.getMessage());
        }
    }

    public static interface InputCallback {
        public void doInput(String var1);
    }
}

