/*
 * Decompiled with CFR 0.152.
 */
package com.walker.location;

import java.util.ArrayList;
import java.util.List;

public class GeoHashHelper {
    public final double Max_Lat = 90.0;
    public final double Min_Lat = -90.0;
    public final double Max_Lng = 180.0;
    public final double Min_Lng = -180.0;
    private final int length = 20;
    private final double latUnit = 1.71661376953125E-4;
    private final double lngUnit = 3.4332275390625E-4;
    private final String[] base32Lookup = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "b", "c", "d", "e", "f", "g", "h", "j", "k", "m", "n", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    private void convert(double min, double max, double value, List<Character> list) {
        if (list.size() > 19) {
            return;
        }
        double mid = (max + min) / 2.0;
        if (value < mid) {
            list.add(Character.valueOf('0'));
            this.convert(min, mid, value, list);
        } else {
            list.add(Character.valueOf('1'));
            this.convert(mid, max, value, list);
        }
    }

    private String base32Encode(String str) {
        String unit = "";
        StringBuilder sb = new StringBuilder();
        for (int start = 0; start < str.length(); start += 5) {
            unit = str.substring(start, start + 5);
            sb.append(this.base32Lookup[this.convertToIndex(unit)]);
        }
        return sb.toString();
    }

    private int convertToIndex(String str) {
        int length = str.length();
        int result = 0;
        for (int index = 0; index < length; ++index) {
            result += str.charAt(index) == '0' ? 0 : 1 << length - 1 - index;
        }
        return result;
    }

    public String encode(double lat, double lng) {
        ArrayList<Character> latList = new ArrayList<Character>();
        ArrayList<Character> lngList = new ArrayList<Character>();
        this.convert(-90.0, 90.0, lat, latList);
        this.convert(-180.0, 180.0, lng, lngList);
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < latList.size(); ++index) {
            sb.append(lngList.get(index)).append(latList.get(index));
        }
        return this.base32Encode(sb.toString());
    }

    public List<String> around(double lat, double lng) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.encode(lat, lng));
        list.add(this.encode(lat + 1.71661376953125E-4, lng));
        list.add(this.encode(lat - 1.71661376953125E-4, lng));
        list.add(this.encode(lat, lng + 3.4332275390625E-4));
        list.add(this.encode(lat, lng - 3.4332275390625E-4));
        list.add(this.encode(lat + 1.71661376953125E-4, lng + 3.4332275390625E-4));
        list.add(this.encode(lat + 1.71661376953125E-4, lng - 3.4332275390625E-4));
        list.add(this.encode(lat - 1.71661376953125E-4, lng + 3.4332275390625E-4));
        list.add(this.encode(lat - 1.71661376953125E-4, lng - 3.4332275390625E-4));
        return list;
    }
}

