/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.support;

import com.walker.push.AbstractPushManager;
import com.walker.push.Notification;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.Pushable;
import java.util.List;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class AsyncPushManager
extends AbstractPushManager {
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    protected PushResult pushOnce(final List<Pushable> pushableList, final Notification notification) throws PushException {
        if (this.threadPoolTaskExecutor == null) {
            throw new IllegalStateException("threadPoolTaskExecutor\u672a\u8bbe\u7f6e");
        }
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    long startTime = System.nanoTime();
                    AsyncPushManager.this.invokePush((Pushable)pushableList.get(0), notification);
                    AsyncPushManager.this.logger.debug("\u5f02\u6b65\u65f6\u95f4:" + (System.nanoTime() - startTime));
                }
                catch (PushException e) {
                    AsyncPushManager.this.logger.error("\u63a8\u9001\u5931\u8d25\uff0cid=" + e.getMessageId(), (Throwable)e);
                    throw new RuntimeException("\u63a8\u9001\uff08\u5f02\u6b65\uff09\u5931\u8d25:" + e.getMessage(), e);
                }
            }
        });
        return null;
    }

    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }
}

