package com.walker.async;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class AsyncBeanManager implements BeanPostProcessor {

	private final transient Logger logger = LoggerFactory.getLogger(getClass());

	private static final Map<Class<?>, Consumer> consumerMap = new HashMap<>(4);
	private static final Map<Class<?>, Producer> producerMap = new HashMap<>(2);

	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
		if(Consumer.class.isAssignableFrom(bean.getClass())){
			consumerMap.put(bean.getClass(), (Consumer)bean);
			logger.info("........[AsyncMsg] find a Consumer: " + beanName);
		} else if(Producer.class.isAssignableFrom(bean.getClass())){
			producerMap.put(bean.getClass(), (Producer)bean);
			logger.info("........[AsyncMsg] find a Producer: " + beanName);
		}
		return bean;
	}

	@Override
	public Object postProcessBeforeInitialization(Object bean, String arg1) throws BeansException {
		return bean;
	}

	public static final Map<Class<?>, Consumer> getConsumerMap(){
		return consumerMap;
	}

	public static final Map<Class<?>, Producer> getProducerMap(){
		return producerMap;
	}

	public static final Consumer getConsumer(Class<?> clazz){
		return consumerMap.get(clazz);
	}
	public static final Producer getProducer(Class<?> clazz){
		return producerMap.get(clazz);
	}
}
