package com.walker.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 通用上下级关系对象
 *
 * @author 时克英
 */
public class LinkedItem<I, P, C> {
    // 当前节点
    private I item;
    // 父节点
    private P parent;
    // 子节点
    private List<C> children;

    /**
     * 默认构造函数
     */
    public LinkedItem() {
    }

    /**
     * 根据当前节点构造对象
     *
     * @param item 当前对象
     */
    public LinkedItem(I item) {
        this.item = item;
    }

    /**
     * 根据当前节点和父节点构造对象
     *
     * @param item   当前节点
     * @param parent 父节点
     */
    public LinkedItem(I item, P parent) {
        this.item = item;
        this.parent = parent;
    }

    /**
     * 根据当前节点、父节点、子节点信息构造对象
     *
     * @param item     当前节点
     * @param parent   父节点对象
     * @param children 子节点信息
     */
    public LinkedItem(I item, P parent, List<C> children) {
        this.item = item;
        this.parent = parent;
        this.children = children;
    }

    /**
     * 增加子节点信息，
     *
     * @param child 子节点
     */
    public void addChild(C child) {
        if (this.children == null) {
            this.children = new ArrayList<>();
        }
        this.children.add(child);
    }

    /**
     * 将所有的childs增加到当前节点
     *
     * @param childs 子节点集合
     */
    public void addChildren(Collection<C> childs) {
        if (this.children == null && (childs != null && childs.size() > 0)) {
            this.children = new ArrayList<>();
            this.children.addAll(childs);
        }
    }

    public I getItem() {
        return item;
    }

    public void setItem(I item) {
        this.item = item;
    }

    public P getParent() {
        return parent;
    }

    public void setParent(P parent) {
        this.parent = parent;
    }

    public List<C> getChildren() {
        return children;
    }

    public void setChildren(List<C> children) {
        this.children = children;
    }
}
