package com.walker.common.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Map生成工具。
 * @author 时克英
 */
public class MapBuilder {
    private Map<String, Object> map = new LinkedHashMap<>();

    /**
     * 私有构造函数
     */
    private MapBuilder() {
    }

    /**
     * 创建一个MapBuilder
     *
     * @return MapBuilder
     */
    public static MapBuilder create() {
        return new MapBuilder();
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @return MapBuilder
     */
    public MapBuilder put(String name, Object val) {
        map.put(name, val);
        return this;
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @return MapBuilder
     */
    public MapBuilder put(String name, boolean val) {
        map.put(name, val);
        return this;
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @return MapBuilder
     */
    public MapBuilder put(String name, int val) {
        map.put(name, val);
        return this;
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @return MapBuilder
     */
    public MapBuilder put(String name, long val) {
        map.put(name, val);
        return this;
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @return MapBuilder
     */
    public MapBuilder put(String name, double val) {
        map.put(name, val);
        return this;
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @return MapBuilder
     */
    public MapBuilder put(String name, float val) {
        map.put(name, val);
        return this;
    }

    /**
     * 增加键值对
     *
     * @param name 键
     * @param val  值
     * @param use  是否增加
     * @param <T>  值类型
     * @return MapBuilder
     */
    public <T> MapBuilder put(String name, T val, boolean use) {
        if (use) {
            put(name, val);
        }
        return this;
    }

    /**
     * 生成Map<String, Object>
     *
     * @param key   键
     * @param value 值
     * @return Map
     */
    public static  Map<String, Object> map(String key, Object value) {
        Map<String, Object> map = new HashMap<>();
        map.put(key, value);
        return map;
    }

    /**
     * 生成Map<String, T>
     *
     * @param key   键
     * @param value 值
     * @return Map
     */
    public static <T> Map<String, T> mapT(String key, T value) {
        Map<String, T> map = new HashMap<>();
        map.put(key, value);
        return map;
    }

    /**
     * 生成Map<String, Object>
     *
     * @return Map
     */
    public Map<String, Object> build() {
        return map;
    }
}
