package com.walker.db.page;

import java.util.List;
import java.util.Map;

/**
 * 带<code>Map</code>类型的分页实现，业务数据为Map集合。</p>
 * @author shikeying
 *
 */
public class MapPager extends GenericPager<Map<String, Object>> {

	public MapPager(List<Map<String, Object>> datas
			, int pageIndex, int pageSize, int totalRows){
		super(datas, pageIndex, pageSize, totalRows);
	}
	
	@Override
	protected Class<?> buildData() {
		return List.class;
	}
	
	public MapPager setDatas(List<Map<String, Object>> datas){
		if(this.datas != null){
			throw new IllegalStateException("datas is not empty.");
		}
		if(datas != null){
			this.datas = datas;
		}
		return this;
	}

}
