package com.walker.db.page;

import com.walker.infrastructure.utils.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * UI层使用的分页对象</p>
 * @author shikeying
 *
 * @param <T>
 */
public class PagerView<T> implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7447015048488224271L;

	private List<T> datas;
	
	private int currentPage = Pager.DEFAULT_PAGE_INDEX;
	
	private int pageSize = Pager.DEFAULT_PAGE_SIZE;
	
	private int pageCount = Pager.DEFAULT_PAGE_COUNT;
	
	private long totalRows = Pager.DEFAULT_TOTAL_ROWS;
	
	/* 点击分页按钮执行的JS方法 */
	private String jsMethod;
	
	/* 本次分页的索引值，即：本页第一条记录索引值，从0开始计算 */
	private long index = 0;
	
	public PagerView(Pager pager, String jsMethod){
		if(StringUtils.isNotEmpty(jsMethod))
			this.jsMethod = jsMethod;
		setPager(pager);
	}
	
	public PagerView(String jsMethod){
//		if(currentPage > 0 )
//			this.currentPage = currentPage;
		if(StringUtils.isNotEmpty(jsMethod))
			this.jsMethod = jsMethod;
	}
	
	@SuppressWarnings("unchecked")
	public void setPager(Pager pager){
		if(pager == null)
			throw new IllegalArgumentException("Please use subclass of '" + Pager.class.getName() + "'.");
		
		setCurrentPage(pager.getPageIndex());
		setTotalRows(pager.getTotalRows());
		setPageSize(pager.getPageSize());
		setPageCount(pager.getPageCount());
		setIndex(pager.getFirstRowIndexInPage());
		
		if(pager instanceof GenericPager<?>){
			GenericPager<T> genericPager = (GenericPager<T>)pager;
			setDatas(genericPager.getDatas());
		} 
//		else if(pager instanceof MapPager){
//			MapPager mapPager = (MapPager)pager;
//			setDatas(mapPager.getDatas());
//		}
		else
			throw new IllegalArgumentException("unknown Pager: " + pager.getClass().getName());
	}
	
	public List<T> getDatas() {
		return datas;
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public int getPageSize() {
		return pageSize;
	}

	public int getPageCount() {
		return pageCount;
	}

	public long getTotalRows() {
		return totalRows;
	}

	public String getJsMethod() {
		return jsMethod;
	}
	
	/**
	 * 返回当前页第一条记录的索引值
	 * @return
	 */
	public long getIndex(){
		return index;
	}

	private void setCurrentPage(int currentPage){
		if(currentPage >= Pager.DEFAULT_PAGE_INDEX)
			this.currentPage = currentPage;
		else
			throw new IllegalArgumentException("currentPage should be >= " + Pager.DEFAULT_PAGE_INDEX);
	}
	
	private void setTotalRows(long totalRows){
		if(totalRows >= 0){
			this.totalRows = totalRows;
		} else
			throw new IllegalArgumentException("totalRows should be more than or equals '0'.");
	}
	
	private void setPageSize(int pageSize){
		if(pageSize >= Pager.DEFAULT_PAGE_SIZE){
			this.pageSize = pageSize;
		} else
			throw new IllegalArgumentException("pageSize should be >= " + Pager.DEFAULT_PAGE_SIZE);
	}
	private void setPageCount(int pageCount){
		if(pageCount >= Pager.DEFAULT_PAGE_COUNT){
			this.pageCount = pageCount;
		} else
			throw new IllegalArgumentException("pageCount should be >= " + Pager.DEFAULT_PAGE_COUNT);
	}
	
	private void setDatas(List<T> datas){
		this.datas = datas;
	}
	
	private void setIndex(long index){
		if(index > 0){
			this.index = index;
		}
	}
}
