package com.walker.di;

import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public abstract class AbstractTemplateGenerator<T> implements TemplateGenerator<T>{

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public T generate(Object option) throws TemplateException {
        if(!this.checkOption(option)){
            throw new TemplateException("option参数校验未通过", null);
        }
        List<Map<String, String>> content = this.acquireWriteContent(option);
        if(StringUtils.isEmptyList(content)){
            throw new TemplateException("未获取到写入模板内容", null);
        }

        return this.writeContent(content, option);
    }

    /**
     * 检测输入参数是否可用，子类可覆盖次方法。<p></p>
     * 该输入源可能是文件流、路径、配置参数等。
     * @param option
     * @return
     */
    protected boolean checkOption(Object option){
        return true;
    }

    /**
     * 获取要写入模板的内容。
     * @param option
     * @return
     */
    protected abstract List<Map<String, String>> acquireWriteContent(Object option);

    /**
     * 向模板中写入模板内容。
     * @param data key = 字段ID, value = 字段描述
     */
    protected abstract T writeContent(List<Map<String, String>> data, Object option) throws TemplateException;
}
