package com.walker.di;

import java.util.List;
import java.util.Map;

/**
 * 批量加载监听器，一批批加载，所以必须监听方式。
 * @author 时克英
 * @date 2023-01-31
 */
public interface BatchLoadListener {

    /**
     * 当批量加载时触发该方法。
     * @param columnsByName 按列存储的数据格式
     * @param fieldNames 列名称集合
     * @param dataSize 数据量
     */
    List<Object[]> onBatchLoad(Map<String, List<String>> columnsByName, String[] fieldNames, int dataSize);
}
