package com.walker.infrastructure;

import com.walker.infrastructure.core.NestedRuntimeException;

/**
 * 应用程序基础运行异常定义，任何业务相关的运行异常定义必须继承该对象。
 * @author shikeying
 *
 */
public class ApplicationRuntimeException extends NestedRuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5785259349421994617L;
	private static final String ERROR_1 = "应用程序发生已知运行。";
	
	public ApplicationRuntimeException(){
		super(ERROR_1);
	}
	
	public ApplicationRuntimeException(String msg){
		super(msg);
	}

	public ApplicationRuntimeException(Throwable cause){
		super("error", cause);
	}

	public ApplicationRuntimeException(String msg, Throwable cause){
		super(msg, cause);
	}
}
