package com.walker.infrastructure.arguments;

import java.util.concurrent.ConcurrentHashMap;

import com.walker.infrastructure.arguments.support.XmlArgumentsManager;
import com.walker.infrastructure.utils.StringUtils;

public abstract class ArgumentsManagerFactory {

//	private static final Object lock = new Object();
	
	private static final ConcurrentHashMap<String, ArgumentsManager> existArgumentsManagers = 
			new ConcurrentHashMap<String, ArgumentsManager>(2);
	
	/**
	 * 创建xml方式配置的可变参数管理器对象。</p>
	 * 系统会管理创建的所有'配置管理器'，可以通过文件名来引用。</br>
	 * 
	 * 通常在系统初始化过程中来通过此方法创建对象。</br>
	 * 如果配置文件在外部存放，filename必须是绝对路径，classpath = false
	 * @param filename 文件名，支持文件名在类路径中或绝对路径。
	 * @param classpath 配置文件是否用的classpath方式
	 * @return
	 */
	public static final ArgumentsManager createXmlArgumentsManager(String filename, boolean classpath){
		assert (StringUtils.isNotEmpty(filename));
		ArgumentsManager exist = existArgumentsManagers.get(filename);
		if(exist != null)
			throw new ArgumentsException("已经存在配置管理器，无法重复创建: " + filename);
		
		XmlArgumentsManager xmlArgumentsManager = new XmlArgumentsManager();
		if(classpath){
			xmlArgumentsManager.setClasspathFileName(filename);
		} else
			xmlArgumentsManager.setFileSystemFileName(filename);
		try {
			xmlArgumentsManager.afterPropertiesSet();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new ArgumentsException("初始化ArgumentManager失败: " + filename, e);
		}
		existArgumentsManagers.put(filename, xmlArgumentsManager);
		
		return xmlArgumentsManager;
	}
	
	public static final ArgumentsManager getArgumentsManager(String filename){
		ArgumentsManager exist = existArgumentsManagers.get(filename);
		if(exist == null)
			throw new ArgumentsException("not found argumentsManager：" + filename);
		return exist;
	}
	
	/**
	 * 系统终止时，销毁所有已经创建的管理器。
	 */
	public static final void destroy(){
		for(ArgumentsManager am : existArgumentsManagers.values()){
			try{
				am.destroy();
			} catch(Exception ex){
//				ex.printStackTrace();
				throw new ArgumentsException("销毁ArgumentsManager失败: " + am.toString(), ex);
			}
		}
	}
}
