package com.walker.infrastructure.arguments;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * 发现并自动注入'应用程序参数配置'的后处理器实现。
 * @author shikeying
 * @date 2014-5-27
 *
 */
public class ArgumentsPostProcessor implements BeanPostProcessor {

	private final transient Logger logger = LoggerFactory.getLogger(getClass());
	
	private ArgumentsManager argumentsManager;
	
	public void setArgumentsManager(ArgumentsManager argumentsManager) {
		this.argumentsManager = argumentsManager;
	}

	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName)
			throws BeansException {
		// TODO Auto-generated method stub
		if(ArgumentsManagerAware.class.isAssignableFrom(bean.getClass())){
			if(argumentsManager == null)
				throw new IllegalStateException("argumentsManager is required!");
			((ArgumentsManagerAware)bean).setArgumentManager(argumentsManager);
			logger.info("........inject argumentsManager into: " + beanName);
		}
		return bean;
	}

	@Override
	public Object postProcessBeforeInitialization(Object bean, String beanName)
			throws BeansException {
		return bean;
	}

}
