package com.walker.infrastructure.arguments;

/**
 * 可变参数定义
 * @author shikeying
 *
 */
public interface Variable {

	String getId();
	
	String getDescription();
	
	VariableType getType();
	
	String getStringValue();
	
	int getIntegerValue();
	
	boolean getBooleanValue();
	
	float getFloatValue();
	
	long getLongValue();

	double getDoubleValue();
	
	/**
	 * 返回默认设置的值，可以不设置，返回<code>null</code>
	 * @return
	 */
	Object getDefaultValue();
}
