package com.walker.infrastructure.arguments.support;

import java.util.ArrayList;
import java.util.List;

import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.arguments.Variable;

public class DefaultGroup implements Group {

	private String id;
	private String name;
	private int order = 0;
	
	private List<Variable> children = new ArrayList<Variable>(16);
	
	public DefaultGroup(){}
	
	public DefaultGroup setId(String id) {
		this.id = id;
		return this;
	}

	public DefaultGroup setName(String name) {
		this.name = name;
		return this;
	}

	public DefaultGroup setOrder(int order) {
		this.order = order;
		return this;
	}

	@Override
	public int compareTo(Group o) {
		// TODO Auto-generated method stub
		if(o == null) return 0;
		return this.order - o.getOrder();
	}

	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return id;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return name;
	}

	@Override
	public int getOrder() {
		// TODO Auto-generated method stub
		return order;
	}

	@Override
	public List<Variable> getChildren() {
		// TODO Auto-generated method stub
		return children;
	}

	public void add(Variable var){
		assert (var != null);
		this.children.add(var);
	}
	
	public void setChildren(List<Variable> list){
		if(list != null){
			this.children.addAll(list);
		}
	}
	
	public String toString(){
		StringBuilder sb = new StringBuilder();
		sb.append("{id = ");
		sb.append(id);
		sb.append(", name = ");
		sb.append(name);
		sb.append(", order = ");
		sb.append(order);
		sb.append(", children size = ");
		sb.append(children.size());
		sb.append("}");
		return sb.toString();
	}
	
	public boolean equals(Object o){
		if(o == null) return false;
		if(o == this) return true;
		if(o instanceof DefaultGroup){
			DefaultGroup dg = (DefaultGroup)o;
			if(dg.id.equals(this.id) && dg.name.equals(this.name) 
					&& dg.order == this.order){
				return true;
			}
		}
		return false;
	}
	
	public int hashCode(){
		return 31 + 11*this.id.hashCode() + this.name.hashCode() + this.order;
	}
}
