package com.walker.infrastructure.core.domx;

import com.walker.infrastructure.core.DomParser;
import com.walker.infrastructure.utils.WorkingTimeTester;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.InputStream;
import java.io.StringReader;

public class JaxbDomParser implements DomParser<Document> {

    @Override
    public Document getDocumentFromXml(String xml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Document create error in SAXException!");
        }
//        catch (IOException e) {
//            e.printStackTrace();
//            throw new RuntimeException("Document create error in IOException!");
//        }
//        catch (ParserConfigurationException e) {
//            this.logger.error("dbf.newDocumentBuilder() error!");
//        }throw new RuntimeException("dbf.newDocumentBuilder() error!");
    }

    @Override
    public Document getDocumentFromStream(InputStream inputStream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(inputStream); } catch (Exception e) {
        }
        throw new RuntimeException("Document create error!");
    }

    @Override
    public boolean isSupported(Class<Object> clazz) {
        return true;
    }

    public static void main(String[] args) {
        StringBuilder XML_INSERT = new StringBuilder();
        XML_INSERT.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XML_INSERT.append("<Root>");
        XML_INSERT.append("<ReqType id=\"myid\">input</ReqType>");
        XML_INSERT.append("<SessionID>会话ID</SessionID>");
        XML_INSERT.append("<Version>当前数据录入操作协议版本</Version>");
        XML_INSERT.append("<TransactionType>事务类型(默认为1)</TransactionType>");
        XML_INSERT.append("</Root>");

        JaxbDomParser parser = new JaxbDomParser();

        for (int i = 0; i < 200; i++)
            new Thread() {
                public void run() {
                    WorkingTimeTester wtt = new WorkingTimeTester();
                    Document document = parser.getDocumentFromXml(XML_INSERT.toString());
                    wtt.stop();
                    System.out.println("============ " + document.toString());
                }
            }.start();
    }
}
