package com.walker.infrastructure.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;

/**
 * 自定义反序列化实现，目前在前端提交表单数据时，value字段可能是多种形式，如：字符串、数组等，<br>
 * 此时fasterxml会报错，尝试通过该自定义序列号看是否能成功。
 * @author 时克英
 * @date 2023-05-21
 * @date 2023-05-22 暂时用不到，而且FasterXml本身带有该对象（同名）。
 */
@Deprecated
public class StringDeserializer extends JsonDeserializer<String> {

    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        return jsonParser.getText();
    }
}
