package com.walker.infrastructure.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ByteTools {

//	private Log log = LogFactory.getLog(this.getClass());

	/**
	 * 生成指定长度的随机数字符串
	 * 
	 * @param intNumber
	 * @return
	 */
	public static String getRandomNum(int intNumber) {
		StringBuilder sb = new StringBuilder(StringUtils.EMPTY_STRING);
		Random random = new Random();
		for (int i = 0; i < intNumber; i++) {
			sb.append(String.valueOf(random.nextInt(10)));
		}
		return sb.toString();
	}

	private static char[] Digit = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A','B', 'C', 'D', 'E', 'F' };
	
	/**
	 * 将一个字节以两位16进制数字表示成字符串
	 * 
	 * @param ib
	 *            字节
	 * @return 字符串，两位
	 */
	public static String byteHEX(byte ib) {
//		char[] Digit = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A','B', 'C', 'D', 'E', 'F' };
		char[] ob = new char[2];
		ob[0] = Digit[(ib >>> 4) & 0X0F];
		ob[1] = Digit[ib & 0X0F];
		String s = new String(ob);
		return s;
	}

	/**
	 * 2byte => 1int
	 * 
	 * @param byHi
	 * @param byLo
	 * @return 1 int
	 */
	public static int byte2int(byte byHi, byte byLo) {
		return (byHi & 0xFF) << 8 | (byLo & 0xFF);
	}

	/**
	 * 4byte => 1int
	 * 
	 * @param HH
	 * @param HL
	 * @param LH
	 * @param LL
	 * @return
	 */
	public static int byte2int(byte HH, byte HL, byte LH, byte LL) {
		return (HH & 0xFF) << 24 | (HL & 0xFF) << 16 | (LH & 0xFF) << 8
				| (LL & 0xFF);
	}

	/**
	 * int 转换为 byte 数组
	 * 
	 * @param i
	 * @return
	 */
	public static byte[] int2bytes(int i) {
		byte[] abyte0 = new byte[4];
		abyte0[3] = (byte) (0xff & i);
		abyte0[2] = (byte) ((0xff00 & i) >> 8);
		abyte0[1] = (byte) ((0xff0000 & i) >> 16);
		abyte0[0] = (byte) ((0xff000000 & i) >> 24);
		return abyte0;
	}
	public static byte[] int2bytes2(int i) {
		byte[] abyte0 = new byte[2];
		abyte0[1] = (byte) (0xff & i);
		abyte0[0] = (byte) ((0xff00 & i) >> 8);
		return abyte0;
	}

	/**
	 * byte[4] 转化为int
	 * 
	 * @param b
	 *            byte[4]
	 * @return int
	 */
	public static int bytes2int(byte[] b) {
		int res = 0;
		res <<= 8;
		res = res | (b[0] & 0xff);
		res <<= 8;
		res = res | (b[1] & 0xff);
		res <<= 8;
		res = res | (b[2] & 0xff);
		res <<= 8;
		res = res | (b[3] & 0xff);
		return res;

	}

	/**
	 * 从一个路径得到文件名
	 * 
	 * @param s
	 * @return
	 */
	public static String getName(String s) {
		String temp = null;
		while (s.indexOf("/") > -1) {
			s = s.substring(s.indexOf("/") + 1);
		}
		temp = s;
		if (temp.indexOf(".") > -1) {
			temp = temp.substring(0, temp.indexOf("."));
		}
		return temp;
	}

	/**
	 * 生成一个唯一的16位的字符串——16进制byte
	 */
	public static byte[] randomByte() {
		String temp = null;
		temp = Long.toString(System.currentTimeMillis(), 16)
				+ Integer.toString(new Random().nextInt(100000) + 100000, 16);
		return ByteTools.hexStr2byteArr(temp);
	}

	public static byte[] cip2bytes(String ip) {
		byte[] temp = new byte[4];
		String temps = null;
		int tempi = 0;
		byte[] tempb = new byte[4];
		for (int i = 0; i < 4; i++) {
			if (i != 3) {
				temps = ip.substring(0, ip.indexOf("."));
				ip = ip.substring(ip.indexOf(".") + 1);
				tempi = Integer.parseInt(temps);
				tempb = int2bytes(tempi);
				System.arraycopy(tempb, 3, temp, i, 1);
			} else {
				tempi = Integer.parseInt(ip);
				tempb = int2bytes(tempi);
				System.arraycopy(tempb, 3, temp, i, 1);
			}
		}

		return temp;
	}

	public static byte[] ip2bytes(String ip) {
		byte[] temp = new byte[4];
		String temps = null;
		int tempi = 0;
		byte[] tempb = new byte[4];
		for (int i = 0; i < 4; i++) {
			if (i != 3) {
				temps = ip.substring(0, ip.indexOf("."));
				ip = ip.substring(ip.indexOf(".") + 1);
				tempi = Integer.parseInt(temps);
				tempb = int2bytes(tempi);
				System.arraycopy(tempb, 3, temp, 3 - i, 1);
			} else {
				tempi = Integer.parseInt(ip);
				tempb = int2bytes(tempi);
				System.arraycopy(tempb, 3, temp, 3 - i, 1);
			}
		}

		return temp;
	}

	/**
	 * 4个字节的byte[]转变为IP地址
	 * */
	public static String bytes2ip(byte[] packet){
		StringBuffer sb = new StringBuffer();
		sb.append(Integer.toString(((byte) packet[0]) & 0xff));
		sb.append(".");
		sb.append(Integer.toString(((byte) packet[1]) & 0xff));
		sb.append(".");
		sb.append(Integer.toString(((byte) packet[2]) & 0xff));
		sb.append(".");
		sb.append(Integer.toString(((byte) packet[3]) & 0xff));
		
		return sb.toString();
	}
	
	/**
	 * 16进制字符串转换为byte []
	 * 
	 * @param hex
	 * @return
	 */
	public static byte[] hexStr2byteArr(String hex) {
		int len = (hex.length() / 2);
		byte[] result = new byte[len];
		char[] achar = hex.toCharArray();
		for (int i = 0; i < len; i++) {
			String item = new String(achar, i * 2, 2);
			result[i] = (byte) Integer.parseInt(item, 16);
		}
		return result;
	}

	/**
	 * 将字符串写入指定文件(当指定的父路径中文件夹不存在时，会最大限度去创建，以保证保存成功！)
	 * 
	 * @param res
	 *            原字符串
	 * @param filePath
	 *            文件路径
	 * @return 成功标记
	 */
	public static boolean string2File(String res, String filePath) {
		boolean flag = true;
		BufferedReader bufferedReader = null;
		BufferedWriter bufferedWriter = null;
		try {
			File distFile = new File(filePath);
			if (!distFile.getParentFile().exists())
				distFile.getParentFile().mkdirs();
			bufferedReader = new BufferedReader(new StringReader(res));
			bufferedWriter = new BufferedWriter(new FileWriter(distFile));
			char buf[] = new char[1024]; // 字符缓冲区
			int len;
			while ((len = bufferedReader.read(buf)) != -1) {
				bufferedWriter.write(buf, 0, len);
			}
			bufferedWriter.flush();
			bufferedReader.close();
			bufferedWriter.close();
		} catch (IOException e) {
			e.printStackTrace();
			flag = false;
			return flag;
		} finally {
			if (bufferedReader != null) {
				try {
					bufferedReader.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return flag;
	}

	/**
	 * 将byte[]转化为16进制字符串
	 * 
	 * @param b
	 *            byte[]
	 * @return 16进制字符串
	 */
	public static String Bytes2HexString(byte[] b) {
//		String ret = StringUtils.EMPTY_STRING;
		StringBuilder ret = new StringBuilder(StringUtils.EMPTY_STRING);
		for (int i = 0; i < b.length; i++) {
			String hex = Integer.toHexString(b[i] & 0xFF);
			if (hex.length() == 1) {
//				hex = '0' + hex;
				hex = Digit[0] + hex;
			}
			ret.append(hex.toUpperCase());
//			ret += hex.toUpperCase();
		}
		return ret.toString();
	}

	/**
	 * 将高字节数组转换为int
	 * 
	 * @param b
	 *            byte[]
	 * @return int
	 */
	public static int hBytesToInt(byte[] b) {
		int s = 0;
		for (int i = 0; i < 3; i++) {
			if (b[i] >= 0) {
				s = s + b[i];
			} else {
				s = s + 256 + b[i];
			}
			s = s * 256;
		}
		if (b[3] >= 0) {
			s = s + b[3];
		} else {
			s = s + 256 + b[3];
		}
		return s;
	}
	
	/**
	 * 由IP形式的字符串转化为long
	 * */
	public static long StringToLong(String ip) {
		long lip = 0;
		String temp = null;
		if (ip!=null && isIPv4(ip)) {
			if (ip.indexOf(".")>-1) {
				temp = ip.substring(0,ip.indexOf("."));
				ip = ip.substring(ip.indexOf(".") + 1);
				lip = lip + Long.parseLong(temp) * 1000000000;
				if (ip.indexOf(".")>-1) {
					temp = ip.substring(0,ip.indexOf("."));
					ip = ip.substring(ip.indexOf(".") + 1);
					lip = lip + Long.parseLong(temp) * 1000000;
					if (ip.indexOf(".")>-1) {
						temp = ip.substring(0,ip.indexOf("."));
						ip = ip.substring(ip.indexOf(".") + 1);
						lip = lip + Long.parseLong(temp) * 1000 + Long.parseLong(ip);
					}else {
						return 0;
					}
				}else {
					return 0;
				}
			}
		}
		
		return lip;
	}
	
	/**
	 * 判断字符串是否是IPv4地址
	 * @param value
	 * @return
	 */
	public static boolean isIPv4(String value) {
		if(value == null)
			return false;
		String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])" +
				"(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
		return value.matches(ip);
	}
	
	/**
	 * 由long转化为IP形式的字符串
	 * */
	public static String LongToString(long lip) {
		String ip = "";
		long temp = 0;
		temp = lip/1000;
		ip = String.valueOf(lip%1000);
		lip = temp/1000;
		ip = String.valueOf(temp%1000) + "." + ip;
		temp = lip/1000;
		ip = String.valueOf(lip%1000) + "." + ip;
		lip = temp/1000;
		ip = String.valueOf(temp%1000) + "." + ip;
		
		return ip;
	}
	
	/**
	 * 获得主键
	 * 
	 * @return 主键
	 */
	public static long getID() {
		DateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
		Random random = new Random();
		String id = df.format(new Date(System.currentTimeMillis()))
				+ random.nextInt(1000);
		try {
			Thread.sleep(1);
		} catch (InterruptedException e) {
		}
		return Long.parseLong(id);
	}
	
	public static String isIdentifier(String identifier){
		String[] Errors={"yes", "身份证号码位数不对!", "身份证号码出生日期超出范围或含有非法字符!", 
				"身份证号码校验错误!", "身份证地区非法!"};
		HashMap<String,String> area=new HashMap<String,String>();
		area.put("11","北京");
		area.put("12","天津");
		area.put("13","河北");
		area.put("14","山西");
		area.put("15","内蒙古");		
		area.put("21","辽宁");
		area.put("22","吉林");
		area.put("23","黑龙江");		
		area.put("31","上海");	
		area.put("32","江苏");
		area.put("33","浙江");
		area.put("34","安徽");
		area.put("35","福建");	
		area.put("36","江西");
		area.put("37","山东");
		area.put("41","河南");	
		area.put("42","湖北");
		area.put("43","湖南");
		area.put("44","广东");	
		area.put("45","广西");
		area.put("46","海南");
		area.put("50","重庆");
		area.put("51","四川");		
		area.put("52","贵州");
		area.put("53","云南");
		area.put("54","西藏");
		area.put("61","陕西");
		area.put("62","甘肃");
		area.put("63","青海");		
		area.put("64","宁夏");
		area.put("65","新疆");
		area.put("71","台湾");
		area.put("81","香港");
		area.put("81","香港");
		area.put("82","澳门");
		area.put("91","国外");
		
		//去掉前后空格，不能小于15位
		identifier=identifier.trim();
		if(identifier.length()<15)
			return Errors[1]; 
		//地区检验 
		if(area.get(identifier.substring(0,2))==null) 
			return Errors[4]; 
		
		String JYM; 
		String M;
		int S,Y;
		String ereg;
		Pattern pattern;
		Matcher matcher;
		//身份号码位数及格式检验 
		switch(identifier.length()){ 
		case 15:
			if ((Integer.parseInt(identifier.substring(6,8))+1900) % 4 == 0 || ((Integer.parseInt(identifier.substring(6,8))+1900) % 100 == 0 && (Integer.parseInt(identifier.substring(6,8))+1900) % 4 == 0 )){ 
				ereg="^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}$";//测试出生日期的合法性 
			} 
			else { 
				ereg="^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}$";//测试出生日期的合法性 
				}
			pattern = Pattern.compile(ereg);
			matcher = pattern.matcher(identifier);
			
				if(matcher.matches()) 
					return Errors[0]; 
				else 
					return Errors[2]; 
			//break; 
		case 18:
				//18位身份号码检测 
				//出生日期的合法性检查  
				//闰年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9])) 
				//平年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8])) 
			if ( Integer.parseInt(identifier.substring(6,8)) % 4 == 0 || (Integer.parseInt(identifier.substring(6,8)) % 100 == 0 && Integer.parseInt(identifier.substring(6,8))%4 == 0 )){ 
				ereg="^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$";//闰年出生日期的合法性正则表达式 
				} 
			else { 
				ereg="^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$";//平年出生日期的合法性正则表达式 
				} 
			pattern = Pattern.compile(ereg);
			matcher = pattern.matcher(identifier);
			
				if(matcher.matches()){//测试出生日期的合法性 
				//计算校验位 
				S = (Integer.parseInt(identifier.substring(0,1)) + Integer.parseInt(identifier.substring(10,11))) * 7 
				+ (Integer.parseInt(identifier.substring(1,2)) + Integer.parseInt(identifier.substring(11,12))) * 9 
				+ (Integer.parseInt(identifier.substring(2,3)) + Integer.parseInt(identifier.substring(12,13))) * 10 
				+ (Integer.parseInt(identifier.substring(3,4)) + Integer.parseInt(identifier.substring(13,14))) * 5 
				+ (Integer.parseInt(identifier.substring(4,5)) + Integer.parseInt(identifier.substring(14,15))) * 8 
				+ (Integer.parseInt(identifier.substring(5,6)) + Integer.parseInt(identifier.substring(15,16))) * 4 
				+ (Integer.parseInt(identifier.substring(6,7)) + Integer.parseInt(identifier.substring(16,17))) * 2 
				+ Integer.parseInt(identifier.substring(7,8)) * 1  
				+ Integer.parseInt(identifier.substring(8,9)) * 6 
				+ Integer.parseInt(identifier.substring(9,10)) * 3 ; 
				Y = S % 11; 
				M = "F"; 
				JYM = "10X98765432"; 
				M = JYM.substring(Y,Y+1);//判断校验位 
					if(M.equals(identifier.substring(17,18))) 
						return Errors[0]; //检测ID的校验位 
					else 
						return Errors[3]; 
				} 
				else 
					return Errors[2]; 
				//break; 
		default: 
				return Errors[1]; 
				//break; 
				} 
	}
}
