package com.walker.infrastructure.utils;

/**
 * 描述：能显示key、value的对象定义
 * @author 时克英
 * @date 2017年6月13日 下午4:11:13
 */

public class KeyValue<k,v> {
	
	private static final String PREFIX = "＋";

	private k key;
	private v value;
	
	private int level = 0;
	
	private String levelPrefix;
	
	public String getLevelPrefix() {
		return levelPrefix;
	}

	/**
	 * 对于树节点，该值代表处于那一层次级别
	 * @return
	 */
	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
		if(level > 0){
			StringBuilder sb = new StringBuilder(4);
			for(int i=0; i<level; i++){
				sb.append(PREFIX);
			}
			levelPrefix = sb.toString();
		}
	}

	public KeyValue(){}
	
	public KeyValue(k key, v value){
		this.key = key;
		this.value = value;
	}
	
	public k getKey() {
		return key;
	}
	public void setKey(k key) {
		this.key = key;
	}
	public v getValue() {
		return value;
	}
	public void setValue(v value) {
		this.value = value;
	}
	
	@Override
	public int hashCode(){
		return key.hashCode();
	}
	
	@Override
	public String toString(){
		return new StringBuilder("[ key=").append(key).append(", value=").append(value)
				.append("]").toString();
	}
	
	// 该方法由具体类型实现
//	public boolean equals(Object kv){
//		if(kv == null){
//			return false;
//		}
//		if(kv instanceof KeyValue){
//			KeyValue obj = (KeyValue)kv;
//			if(obj.key.){
//				
//			}
//		}
//	}
}
