package com.walker.infrastructure.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 类名称：LongDateHelper
 * 
 * 类描述：long类型的日期的处理帮助类
 * 
 * 功能表述：实现long类型的日期的几种辅助处理 1、得到给定日期的当月或者下一月的第一天。 2、得到给定日期的当月或者下一月的第最后一天。
 * 3、得到给定日期的毫秒数。 4、设置给定日期的天。
 * 
 * 编写人：李彬 编写日期：2003年08月21日
 */
public class LongDateHelper {
	
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
	
	private static final SimpleDateFormat sdfDatetime = new SimpleDateFormat("yyyyMMddHHmmss");
	
	private static final SimpleDateFormat normalFormat = new SimpleDateFormat("yyyy-MM-dd");
	
    /**
     * @说明：设置给定日期的日为给定参数的日。
     * @author 李彬
     * @date 2007-4-14
     * @param longDate
     *            给定日期
     * @param longDay
     *            给定的日
     * @return
     */
    public long setDay(long longDate, long longDay) {
        // 日历对象
        Calendar calendar = Calendar.getInstance();
        
        // 日期格式
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        
        // 转换给定的日
        int intDay = (int)longDay;
        
        // 新的日期
        long longNewDate = 0;
        
        // 转换给定的日期
        String strDate = String.valueOf(longDate);
        
        // 得到年
        int year = Integer.parseInt(strDate.substring(0, 4));
        // 得到月
        int month = Integer.parseInt(strDate.substring(4, 6));
        // 得到日
        // int day = Integer.parseInt(strDate.substring(6, 8));
        
        // 要设置的日 大于 28进行如下处理
        if (intDay > 28) {
            
            // 得到本月的最后一天
            long currMonthLastDay = getMonthLastDay(longDate, 1);
            
            // 得到最后一天的日
            int lastDay = Integer.parseInt(String.valueOf(currMonthLastDay).substring(6, 8));
            
            // 如果要设置的日大于本月最后的日，则设置为最后的日
            if (intDay > lastDay) {
                intDay = lastDay;
            }
        }
        
        // 设置日期数据
        calendar.set(year, month - 1, intDay);
        
        // 得到新的日期
        longNewDate = Long.parseLong(sdf.format(calendar.getTime()));
        
        // 返回
        return longNewDate;
    }
    
    /**
     * 名称：getMonthFirstDay 功能：得到给定日期的当月或下一个月的第一天。 输入参数： long:longDate:给定的日期
     * int:flag:标志；1：当月；0：下一个月。 返回值： long:当月第一天的日期 编写人：李彬 编写时间：2003年08月21日
     */
    public static long getMonthFirstDay(long longDate, int flag) {
        // 日历对象
        Calendar calendar = Calendar.getInstance();
        
        // 日期格式
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        
        // 新的日期
        long longNewDate = 0;
        
        // 转换给定的日期
        String strDate = String.valueOf(longDate);
        
        // 如果标志错误，设置为1
        if ((flag < 0) || (flag > 1)) {
            flag = 1;
        }
        
        // 得到年
        int year = Integer.parseInt(strDate.substring(0, 4));
        // 得到月
        int month = Integer.parseInt(strDate.substring(4, 6)) - flag;
        // 日
        int day = 1;
        
        // 设置日历
        calendar.set(year, month, day);
        
        // 得到数据
        longNewDate = Long.parseLong(sdf.format(calendar.getTime()));
        
        // 返回
        return longNewDate;
    }
    
    /**
     * 返回当月最后一天
     * 时克英
     * @return
     */
    public static long getLastDayOfMonth(){
    	// 日期格式
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        
    	Calendar lastDate = Calendar.getInstance();

    	lastDate.set(Calendar.DATE,1);//设为当前月的1号

    	lastDate.add(Calendar.MONTH,1);//加一个月，变为下月的1号

    	lastDate.add(Calendar.DATE,-1);//减去一天，变为当月最后一天
    	
    	return Long.parseLong(sdf.format(lastDate.getTime()));
    }
    
    /**
     * 返回当月第一天日期字符串，如：2014-03-01
     * @return
     */
    public static String getFirstDayOfMonth(){
    	return normalFormat.format(getFirstDateOfMonth());
    }
    
    public static Date getFirstDateOfMonth(){
    	Calendar lastDate = Calendar.getInstance();
    	lastDate.set(Calendar.DATE,1);//设为当前月的1号
    	return lastDate.getTime();
    }
    
    public static long getFirstDayOfPremonth(){
    	// 日期格式
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        
    	Calendar lastDate = Calendar.getInstance();

    	lastDate.set(Calendar.DATE,1);//设为当前月的1号

    	lastDate.add(Calendar.MONTH,-1);//减一个月，变为上月的1号
    	return Long.parseLong(sdf.format(lastDate.getTime()));
    }
    
    public static long getLastDayOfPremonth(){
    	// 日期格式
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        
    	Calendar lastDate = Calendar.getInstance();

    	lastDate.set(Calendar.DATE,1);//设为当前月的1号

//    	lastDate.add(Calendar.MONTH,-1);//减一个月，变为上月的1号
    	lastDate.add(Calendar.DATE,-1);//减去一天，变为上月最后一天
    	
    	return Long.parseLong(sdf.format(lastDate.getTime()));
    }
    /**
     * 名称：getMonthLastDay 功能：得到给定日期的当月或下一个月的最后一天。 输入参数： long:longDate:给定的日期
     * int:flag:标志；1：当月；0：下一个月。 返回值： long:当月最后一天的日期 编写人：李彬 编写时间：2003年08月21日
     */
    @Deprecated
    public static long getMonthLastDay(long longDate, int flag) {
        // 日期格式
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        
        // 新的日期
        long longNewDate = 0;
        
        // 如果标志错误，设置为1
        if ((flag < 0) || (flag > 1)) {
            flag = 1;
        }
        
        // 得到最后一天
        long longNextMonthFirstDay = getMonthFirstDay(longDate, flag);
        
        // 一天的毫秒数
        long longDayTime = 86400000; // 1000 * 3600 * 24;
        
        // 得到毫秒数
        long longTime = getTimeOfDate(longNextMonthFirstDay);
        
        // 得到日期
        Date newDate = new Date(longTime - longDayTime);
        longNewDate = Long.parseLong(sdf.format(newDate));
        
        // 返回
        return longNewDate;
    }
    
    /**
     * 名称：getTimeOfDate 功能：得到指定日期的毫秒数 输入参数： long:longDate:指定的日期 返回值： long:毫秒数
     * 编写人：李彬 编写时间：2003年08月21日
     */
    public static long getTimeOfDate(long longDate) {
        Calendar calendar = Calendar.getInstance();
        String strDate = String.valueOf(longDate);
        long longTimes = 0;
        int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        calendar.set(year, month, day);
        longTimes = calendar.getTime().getTime();
        return longTimes;
    }
    
    public long getTransDate(long date, int rate, int flag) {
        int year = Integer.parseInt(String.valueOf(date).substring(0, 4));
        int month = Integer.parseInt(String.valueOf(date).substring(4, 6)) - 1;
        int day = Integer.parseInt(String.valueOf(date).substring(6, 8));
        
        int newYear = 0;
        int newMonth = 0;
        int newDay = 0;
        
        if (flag == 0) {
            newYear = year + rate;
            newMonth = month;
            newDay = day;
        } else if (flag == 1) {
            newMonth = month + rate;
            newYear = year;
            newDay = day;
        } else {
            newDay = day + rate;
            newYear = year;
            newMonth = month;
        }
        
        Calendar calendar = Calendar.getInstance();
        calendar.set(newYear, newMonth, newDay);
        Date now = calendar.getTime();
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return Long.parseLong(sdf.format(now));
    }
    
    /**
     * 功能: 在yyyyMMddhhmmss格式的long型日期上 加上数秒后得到新的时间
     * 
     * @param old
     *            原时间
     * @param seconds
     *            增加的秒数
     * @return long 新的时间
     * @author 乔爱国
     */
    public static long addSeconds(long old, long seconds) {
        long year = old / 10000000000L;
        long month = (old - year * 10000000000L) / 100000000L;
        long day = (old - year * 10000000000L - month * 100000000L) / 1000000L;
        long hour = (old - year * 10000000000L - month * 100000000L - day * 1000000L) / 10000L;
        long minus = (old - year * 10000000000L - month * 100000000L - day * 1000000L - hour * 10000L) / 100L;
        long second = old - year * 10000000000L - month * 100000000L - day * 1000000L - hour * 10000L - minus * 100L;
        Calendar cl = Calendar.getInstance();
        cl.set((int)year, (int)month - 1, (int)day, (int)hour, (int)minus, (int)(second));
        Date date = new Date(cl.getTime().getTime() + seconds * 1000);
//        java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyyMMddHHmmss");
        String sdate = sdfDatetime.format(date);
        return Long.parseLong(sdate);
    }
    
    /**
     * 得到两个时间点之间相差的秒数
     * 
     * @param begin
     *            long 起始时间(14位)
     * @param end
     *            long 终止时间(14位)
     * @throws Exception
     *             时间格式不是14位
     * @return long 间隔秒数
     * @author 乔爱国
     */
    public static long secondsBetween(long begin, long end) throws Exception {
        String strBegin = "" + begin;
        String strEnd = "" + end;
        if (strBegin.length() != 14 || strEnd.length() != 14)
            throw new Exception("时间格式不对,必须使用14位的时间格式");
        
        Calendar calendar = Calendar.getInstance();
        
        calendar.set(Integer.parseInt(strBegin.substring(0, 4)), Integer.parseInt(strBegin.substring(4, 6)) - 1, Integer.parseInt(strBegin.substring(6, 8)), Integer
                .parseInt(strBegin.substring(8, 10)), Integer.parseInt(strBegin.substring(10, 12)), Integer.parseInt(strBegin.substring(12, 14)));
        long longBegin = calendar.getTimeInMillis();
        
        calendar.set(Integer.parseInt(strEnd.substring(0, 4)), Integer.parseInt(strEnd.substring(4, 6)) - 1, Integer.parseInt(strEnd.substring(6, 8)), Integer.parseInt(strEnd.substring(8, 10)),
                Integer.parseInt(strEnd.substring(10, 12)), Integer.parseInt(strEnd.substring(12, 14)));
        long longEnd = calendar.getTimeInMillis();
        
        return (longEnd - longBegin) / 1000;
    }
    
    /**
     * 方法名称：getDadsBetween 功能描述：获取两个long型日期之间的天数 参数说明：
     * begin：开始时间，时间格式应符合LongCalendar 即20040103或20040103125959 end: 结束时间
     * 格式同begin 编写人：陈建新
     */
    public static long getDaysBetween(long begin, long end) throws Exception {
        try {
            long returnValue = 0;
            // 检验传来的日期格式
            String strBegin = String.valueOf(begin);
            String strEnd = String.valueOf(end);
            if (strBegin.length() != 8)
                throw new RuntimeException("日期格式不正确");
            
            int yearBegin = Integer.parseInt(strBegin.substring(0, 4), 10);
            int monthBegin = Integer.parseInt(strBegin.substring(4, 6), 10);
            int dayBegin = Integer.parseInt(strBegin.substring(6, 8), 10);
            
            int yearEnd = Integer.parseInt(strEnd.substring(0, 4), 10);
            int monthEnd = Integer.parseInt(strEnd.substring(4, 6), 10);
            int dayEnd = Integer.parseInt(strEnd.substring(6, 8), 10);
            
            // System.out.println(yearBegin + "-" + monthBegin + "-" +
            // dayBegin);
            Calendar calendar = Calendar.getInstance();
            
            calendar.set(yearBegin, monthBegin - 1, dayBegin);
            long milliSecondsBegin = calendar.getTime().getTime();
            calendar.set(yearEnd, monthEnd - 1, dayEnd);
            long milliSecondsEnd = calendar.getTime().getTime();
            returnValue = (milliSecondsEnd - milliSecondsBegin) / 86400000L;
            return returnValue;
        } catch (Exception e) {
            throw e;
        }
    }
    
    /**
     * 说明：返回指定时间之后的时间，可正可负，例如：给定20071201000000，减10天，得到新的日期
     * 作者：时克英
     * 时间：12 7, 2007
     */
    public static long getAfterLongTime(long oldTime, int dayNum){
    	Calendar calendar = Calendar.getInstance();
    	String strDate = String.valueOf(oldTime);
    	int year = Integer.parseInt(strDate.substring(0, 4));
        int month = Integer.parseInt(strDate.substring(4, 6)) - 1;
        int day = Integer.parseInt(strDate.substring(6, 8));
        int hour = Integer.parseInt(strDate.substring(8, 9));
        int minute = Integer.parseInt(strDate.substring(9,10));
        int second = Integer.parseInt(strDate.substring(10, 11));
        
        calendar.set(year, month, day, hour, minute, second);
        calendar.add(Calendar.DATE, dayNum);
        
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String result = sdfDatetime.format(calendar.getTime());
        return Long.parseLong(result);
    }
    
    public static void main(String[] s) {
        // long l = LongDateHelper.addSeconds(20040106000000L,3600L*24*55);
        // System.out.print(l);
        // System.out.println();
        try {
            System.out.println(LongDateHelper.getDaysBetween(20041101, 20041202));
            System.out.println("---------" + getAfterLongTime(20071205121212L, -1));
            System.out.println(getFirstDayOfPremonth());
            System.out.println(getLastDayOfMonth());
            System.out.println(getFirstDayOfMonth());
        } catch (Exception e) {
            System.out.println(e);
        }
    }
}
