package com.walker.infrastructure.utils;

public class PasswordUtils {

    public static final int LEVEL_01_LOW = 1;
    public static final int LEVEL_02_MEDIUM = 2;
    public static final int LEVEL_03_HIGH = 3;
    public static final int LEVEL_04_VERY_HIGH = 4;

    public static final String REGEX_ONLY_LOW_CASE = "[a-z]";
    public static final String REGEX_ONLY_UPPER_CASE = "[A-Z]";
    public static final String REGEX_ONLY_DIGIT = "[0-9]";
    public static final String REGEX_ONLY_SPECIAL_CHAR = "[0-9,A-Z,a-z]";

    /**
     * 过滤校验特殊字符，在密码输入中，不能存在不支持的字符。
     * @param text
     * @return 如果出现不支持字符，则返回错误提示
     * @date 2023-08-04
     */
    public static final String filterText(String text){
        if(StringUtils.isEmpty(text)){
            return "请设置过滤字符串";
        }
        char c = 0;
        for(int i=0; i<text.length(); i++){
            c = text.charAt(i);
            if(c == 32){
                return "不能存在空格";
            }
            if(c == 42){
                return "不能存在*";
            }
            if(c == 60 || c == 62){
                return "不能存在尖括号";
            }
            if(c >= 91 && c <= 93){
                return "不能存在[\\]符号";
            }
            if(c == 47){
                return "不能存在斜杠";
            }
            if(c == 126){
                // ~ 波浪号也是可以的
                continue;
            }
            if( c >= 33 && c <= 122){
                continue;
            } else {
                return "不支持的符号:" + c;
            }
        }
        return null;
    }

    /**
     * 校验密码安全等级
     * @param password 原始密码
     * @param level 设置验证等级，[1,2,3,4]
     * @return 返回是否成功
     * @date 2023-08-03
     */
    public static final boolean validateComplex(String password, int level){
        if(level == LEVEL_01_LOW){
            if (isConditionRule(password, REGEX_ONLY_LOW_CASE)
                || isConditionRule(password, REGEX_ONLY_DIGIT)){
                return true;
            }
            return false;
        }
        if(level == LEVEL_02_MEDIUM){
            if (isConditionRule(password, REGEX_ONLY_LOW_CASE)
                && isConditionRule(password, REGEX_ONLY_DIGIT)){
                return true;
            }
            return false;
        }
        if(level == LEVEL_03_HIGH){
            if (isConditionRule(password, REGEX_ONLY_LOW_CASE)
                    && isConditionRule(password, REGEX_ONLY_UPPER_CASE) && isConditionRule(password, REGEX_ONLY_DIGIT)){
                return true;
            }
            return false;
        }
        if(level == LEVEL_04_VERY_HIGH){
            if (isConditionRule(password, REGEX_ONLY_LOW_CASE)
                    && isConditionRule(password, REGEX_ONLY_UPPER_CASE) && isConditionRule(password, REGEX_ONLY_DIGIT)
                    && (password.replaceAll(REGEX_ONLY_SPECIAL_CHAR, StringUtils.EMPTY_STRING).length() > 0)){
                return true;
            }
            return false;
        }
        return false;
    }

    private static final boolean isConditionRule(String password, String regex){
        return password.length() - password.replaceAll(regex, StringUtils.EMPTY_STRING).length() > 0;
    }
}
