package com.walker.infrastructure.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class StreamUtils {

    /**
     * 按某个指定字段去重
     *
     * @param keyExtractor 需要去重的字段
     * @return java.util.function.Predicate<T>
     * @author 时克英
     * @date 2023-12-15
     */
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}
