package com.walker.infrastructure.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingTimeTester {

	private transient Logger logger = LoggerFactory.getLogger(this.getClass());
	
	private final long startTime;
	private long endTime = 0;
	
	private String name;
	
	public WorkingTimeTester(){
		startTime = System.nanoTime();
	}
	
	public WorkingTimeTester(String name){
		this.name = name;
		startTime = System.nanoTime();
	}
	
	public void stop(){
		endTime = System.nanoTime();
		if(logger.isDebugEnabled()){
			logger.debug("//************ " + name + " times = " + (endTime - startTime) + " nano seconds!");
		}
	}
}
