package com.walker.push;

import java.util.List;

/**
 * 推送管理器定义，负责推送处理，外部调用该对象。
 * @author 时克英
 * @date 2023-04-21
 */
public interface PushManager {

    void register(Pushable pushable);

    /**
     * 推送通知，当指定了推送者id时，优先使用。
     * @param notification
     * @param pushableId 指定的推送者id，只有同一个通道存在多个实现时可用。
     * @return
     */
    PushResult push(Notification notification, String pushableId);

    /**
     * 推送短信接口单独定义，因为平台业务中需要重新实现，包装。
     * @param notification
     * @return
     * @date 2023-04-25
     * @date 2023-04-26 去掉mock参数，直接由通道决定是否测试
     */
    PushResult pushSms(Notification notification);

    PushResult push(List<Notification> list);

    void addStrategy(Strategy strategy);

    /**
     * 返回已注册的推送对象集合。
     * @return
     * @date 2023-04-25
     */
    List<Pushable> getPushList();

    /**
     * 根据通道类型，返回该类型下推送对象（集合），可能会存在多个。
     * @param channel
     * @return
     * @date 2023-04-25
     */
    List<Pushable> getPushList(NotificationChannel channel);

    /**
     * 根据索引值，获取推送者对象。
     * @param id 推送对象id
     * @return
     * @date 2023-04-25
     */
    Pushable getPushObject(String id);

    /**
     * 对于普通消息推送，存在多通道时，是否支持并行（全部推送），<br>
     * 如果为否，则表示：只要一个通道完成即可。
     * @return
     * @date 2023-04-26
     */
    boolean isMessageParallel();

    /**
     * 返回普通消息，推送的配置的通道索引集合。
     * @return
     * @date 2023-04-26
     */
    List<String> getMessageChannelNames();

    /**
     * 设置异步推送者需要的监听器。
     * @param listener
     * @date 2023-04-27
     */
    void setAsyncListener(PushStatusListener listener);
}
