package com.walker.push;

/**
 * 推送状态监听器定义，让调用方可以在接收到状态时处理业务。
 * <p>该对象目前使用在异步调用中，如：短信推送者等。</p>
 * @author 时克英
 * @date 2023-04-24
 */
public interface PushStatusListener {

    /**
     * 当调用成功时
     * @param notification
     * @param option
     */
    void onSuccess(Notification notification, Object option, NotificationChannel channel);

    /**
     * 当调用异常时
     * @param notification
     * @param error
     */
    void onException(Notification notification, String error, NotificationChannel channel);
}

