package com.walker.push;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 通用短信消息定义，一般现在都要求使用模板发送。
 * @author 时克英
 * @date 2023-04-23
 */
public class SmsMessage implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[templateId=").append(this.templateId)
                .append(", mobileList=").append(this.mobileList)
                .append(", templateParam=").append(this.templateParam)
                .append("]").toString();
    }

    public void addMobile(String mobile){
        this.mobileList.add(mobile);
    }

    public void addParam(String key, String value){
        this.templateParam.put(key, value);
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public List<String> getMobileList() {
        return mobileList;
    }

    public void setMobileList(List<String> mobileList) {
        this.mobileList = mobileList;
    }

    public Map<String, String> getTemplateParam() {
        return templateParam;
    }

    public void setTemplateParam(Map<String, String> templateParam) {
        this.templateParam = templateParam;
    }

    private String templateId;
    private List<String> mobileList = new ArrayList<>(4);
    private Map<String, String> templateParam = new HashMap<>(4);
}
