package com.walker.push;

/**
 * 推送策略定义，通过策略实现消息的频率或过滤等内容。
 * @author 时克英
 * @date 2023-04-21
 */
public interface Strategy {

    /**
     * 是否允许放行，如果返回：false表明未通过策略检查，不能发送。
     * @param notification
     * @return
     */
    boolean access(Notification notification);

    /**
     * 唯一标识
     * @return
     */
    String getId();
}
