package com.walker.push.support;

import com.walker.push.AbstractPushManager;
import com.walker.push.Notification;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.Pushable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.List;

/**
 * 异步任务执行的推送管理器实现。
 * <p>这些主要是针对推送者为'同步模式'的情况。</p>
 * @author 时克英
 * @date 2023-04-24
 */
public abstract class AsyncPushManager extends AbstractPushManager {

    @Override
    protected PushResult pushOnce(List<Pushable> pushableList, Notification notification) throws PushException {
        if(this.threadPoolTaskExecutor == null){
            throw new IllegalStateException("threadPoolTaskExecutor未设置");
        }
        this.threadPoolTaskExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    long startTime = System.nanoTime();
                    invokePush(pushableList.get(0), notification);
                    logger.debug("异步时间:" + (System.nanoTime() - startTime));
                } catch (PushException e) {
                    logger.error("推送失败，id=" + e.getMessageId(), e);
                    throw new RuntimeException("推送（异步）失败:" + e.getMessage(), e);
                }
            }
        });
        return null;
    }

//    private class InterTask implements Runnable{
//        private Pushable pushable;
//        private Notification notification;
//
//        public InterTask(Pushable pushable, Notification notification){
//            this.pushable = pushable;
//            this.notification = notification;
//        }
//
//        @Override
//        public void run() {
//            try {
//                invokePush(pushable, notification);
//            } catch (PushException e) {
//                logger.error("推送失败，id=" + e.getMessageId(), e);
//                throw new RuntimeException("推送（异步）失败:" + e.getMessage(), e);
//            }
//        }
//    }

    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
}
