package com.walker.queue;

import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;

/**
 * 消息实体，所有队列消息都需要继承此类。
 * @author 时克英
 * @date 2023-09-18
 */
public abstract class MqBaseMessage {

    /**
     * 业务键，用于RocketMQ控制台查看消费情况
     * @return
     */
    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 发送消息来源，用于排查问题
     * @return
     */
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    /**
     * 发送时间，格式：20230919155102
     * @return
     */
    public long getSendTime() {
        return sendTime;
    }

    public void setSendTime(long sendTime) {
        this.sendTime = sendTime;
    }

    /**
     * 重试次数。
     * @return
     */
    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    /**
     * 返回消息主题，由发送方提供。
     * @return
     */
    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    protected String topic;

    /**
     * 业务键，用于RocketMQ控制台查看消费情况
     */
    protected String key;
    /**
     * 发送消息来源，用于排查问题
     */
    protected String source = StringUtils.EMPTY_STRING;

    /**
     * 发送时间
     */
    protected long sendTime = DateUtils.getDateTimeNumber();

    /**
     * 重试次数，用于判断重试次数，超过重试次数发送异常警告
     */
    protected int retryTimes = 0;

    @Override
    public String toString() {
        return "MqBaseMessage{" +
                "key='" + key + '\'' +
                ", source='" + source + '\'' +
                ", sendTime=" + sendTime +
                ", retryTimes=" + retryTimes +
                ", topic=" + topic +
                '}';
    }
}
