package com.walker.queue;

import java.util.List;

import com.walker.async.Consumer;

/**
 * 队列管理器定义
 * @author 时克英
 * @date 2018-11-28
 *
 */
public interface QueueManager {

	/**
	 * 队列管理器唯一编号，也可用于多个时排序
	 * @return
	 */
	int getId();
	
	String getName();
	
	/**
	 * 把数据传送到队列中，以便于异步处理。
	 * @param key 队列名称
	 * @param data 消息对象
	 * @param option 选项（未使用）
	 * @throws QueueException
	 */
	void push(String key, Object data, Object option) throws QueueException;
	
	void setConsumers(List<Consumer> consumerList);
}
