/*
 * Decompiled with CFR 0.152.
 */
package com.walker.common.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotReadablePropertyException;

public class ConvertUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConvertUtil.class);

    public static <T> Object convert(String value, Class<T> clazz) {
        try {
            String typeName = clazz.getCanonicalName();
            if (typeName.equals("java.lang.String")) {
                return value;
            }
            if (value == null || value.equals("") || value.equals("null") || value.equals("undefined")) {
                return null;
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return Boolean.parseBoolean(value);
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return Integer.parseInt(value);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return Short.parseShort(value);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return Long.parseLong(value);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return Double.parseDouble(value);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(value);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(value);
            }
            if (typeName.equals("java.sql.Date")) {
                return Date.valueOf(value.substring(0, 10));
            }
            if (typeName.equals("java.sql.Time")) {
                return Time.valueOf(value);
            }
            if (typeName.equals("java.sql.Timestamp")) {
                if (value.trim().length() == 10) {
                    return Timestamp.valueOf(value.trim() + " 00:00:00");
                }
                return Timestamp.valueOf(value);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("convert exception : value -> {}, type -> {}", new Object[]{value, clazz});
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> Object convert(Object value, Class<T> clazz) {
        return ConvertUtil.convert(ConvertUtil.createString(value), clazz);
    }

    public static Map<String, Object> convertKeyToLowerCase(Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        try {
            Map mapDest = (Map)sourceMap.getClass().newInstance();
            for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                mapDest.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            return mapDest;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), e);
        }
    }

    public static int toInt(Object obj) {
        if (obj == null) {
            return Integer.MIN_VALUE;
        }
        return ConvertUtil.createInteger(obj);
    }

    public static int toInt(Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return ConvertUtil.createInteger(obj);
    }

    public static long toLong(Object obj) {
        if (obj == null) {
            return Long.MIN_VALUE;
        }
        return ConvertUtil.createLong(obj);
    }

    public static long toLong(Object obj, long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return ConvertUtil.createLong(obj);
    }

    public static double toDouble(Object obj) {
        if (obj == null) {
            return Double.MIN_VALUE;
        }
        return ConvertUtil.createDouble(obj);
    }

    public static double toDouble(Object obj, double defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return ConvertUtil.createDouble(obj);
    }

    public static boolean toBoolean(Object obj) {
        return obj != null && ConvertUtil.createBoolean(obj) != false;
    }

    public static boolean toBoolean(Object obj, boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return ConvertUtil.createBoolean(obj);
    }

    public static String createString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public static Integer createInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.valueOf(ConvertUtil.createString(obj));
    }

    public static Long createLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return Long.valueOf(ConvertUtil.createString(obj));
    }

    public static Double createDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return Double.valueOf(ConvertUtil.createString(obj));
    }

    public static BigDecimal createBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(ConvertUtil.createString(obj));
    }

    public static Boolean createBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(ConvertUtil.createString(obj));
    }

    public static <T> T toObject(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        try {
            String typeName = targetClass.getCanonicalName();
            if (typeName.equals("java.util.Map") || typeName.equals("java.util.HashMap")) {
                HashMap t = new HashMap();
                ConvertUtil.copyProperties(source, t);
                return (T)t;
            }
            if (typeName.equals("java.util.LinkedHashMap")) {
                LinkedHashMap t = new LinkedHashMap();
                ConvertUtil.copyProperties(source, t);
                return (T)t;
            }
            T t = targetClass.newInstance();
            ConvertUtil.copyProperties(source, t);
            return t;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e);
        }
    }

    public static void copyProperties(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        if (source instanceof Map) {
            PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(target.getClass());
            Map map = (Map)source;
            try {
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    if (!map.containsKey(descriptor.getName())) continue;
                    Method writeMethod = descriptor.getWriteMethod();
                    Object value = map.get(descriptor.getName());
                    writeMethod.invoke(target, ConvertUtil.convert(value, writeMethod.getParameterTypes()[0]));
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e);
            }
        } else if (target instanceof Map) {
            try {
                PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(source.getClass());
                Map map = (Map)target;
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    Method readMethod = descriptor.getReadMethod();
                    map.put(descriptor.getName(), readMethod.invoke(source, new Object[0]));
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e);
            }
        } else {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
    }

    public static void copyPropertiesIgnoreNull(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        if (source instanceof Map) {
            PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(target.getClass());
            Map map = (Map)source;
            try {
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    if (!map.containsKey(descriptor.getName())) continue;
                    Method writeMethod = descriptor.getWriteMethod();
                    Object value = map.get(descriptor.getName());
                    writeMethod.invoke(target, ConvertUtil.convert(value, writeMethod.getParameterTypes()[0]));
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e);
            }
        } else if (target instanceof Map) {
            try {
                PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(source.getClass());
                Map map = (Map)target;
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    Method readMethod = descriptor.getReadMethod();
                    map.put(descriptor.getName(), readMethod.invoke(source, new Object[0]));
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e);
            }
        } else {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])ConvertUtil.getNullPropertyNames(source));
        }
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = null;
            try {
                srcValue = src.getPropertyValue(pd.getName());
            }
            catch (NotReadablePropertyException e) {
                logger.error(pd.getName() + "\u5c5e\u6027\u83b7\u53d6\u51fa\u9519", (Throwable)e);
            }
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static <T> List<T> toList(List<?> list, Class<T> targetClass) {
        if (list == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object obj : list) {
            result.add(ConvertUtil.toObject(obj, targetClass));
        }
        return result;
    }

    public static <T> List<List<T>> partition(List<T> list, int chunkSize) {
        int nextInc;
        if (list == null) {
            return null;
        }
        if (chunkSize <= 0) {
            throw new ApplicationRuntimeException("chunkSize \u5fc5\u987b\u5927\u4e8e0.");
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int index = 0; index < list.size(); index += nextInc) {
            nextInc = Math.min(list.size() - index, chunkSize);
            result.add(list.subList(index, index + nextInc));
        }
        return result;
    }

    public static String convert(String ... datas) throws Exception {
        if (datas == null || datas.length < 0 || datas.length % 2 == 1) {
            throw new ApplicationRuntimeException("\u8bf7\u786e\u4fdd\u53c2\u6570\u6570\u91cf\u5927\u4e8e0\u4e14\u4e3a\u5076\u6570\uff01");
        }
        int dataSize = datas.length / 2;
        ArrayList<ObjectNode> resultList = new ArrayList<ObjectNode>(4);
        int dataIndex = -1;
        HashMap<String, Object> map = null;
        for (int i = 0; i < dataSize; ++i) {
            dataIndex = i * 2;
            map = new HashMap<String, Object>(8);
            map.put("name", datas[dataIndex]);
            map.put("value", datas[dataIndex + 1]);
            resultList.add(JsonUtils.mapToObjectNode(map));
        }
        return JsonUtils.toJsonArray(resultList);
    }

    public static String convert3(String ... datas) throws Exception {
        if (datas == null || datas.length < 0 || datas.length % 3 != 0) {
            throw new ApplicationRuntimeException("\u8bf7\u786e\u4fdd\u53c2\u6570\u6570\u91cf\u5927\u4e8e0\u4e14\u4e3a3\u7684\u500d\u6570\uff01");
        }
        Object jsonData = null;
        int dataSize = datas.length / 3;
        ArrayList<ObjectNode> resultList = new ArrayList<ObjectNode>(4);
        int dataIndex = -1;
        HashMap<String, Object> map = null;
        for (int i = 0; i < dataSize; ++i) {
            dataIndex = i * 3;
            map = new HashMap<String, Object>(8);
            map.put("name", datas[dataIndex]);
            map.put("value", datas[dataIndex + 1]);
            map.put("show", datas[dataIndex + 2]);
            resultList.add(JsonUtils.mapToObjectNode(map));
        }
        return JsonUtils.toJsonArray(resultList);
    }

    public static <T> T convertStrPropBlank(T bean) {
        if (bean != null) {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtils.getPropertyDescriptors(bean.getClass())) {
                if (!propertyDescriptor.getPropertyType().getName().equals("java.lang.String")) continue;
                try {
                    if (propertyDescriptor.getReadMethod().invoke(bean, new Object[0]) != null) continue;
                    propertyDescriptor.getWriteMethod().invoke(bean, "");
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return bean;
    }

    public static Map<String, Object> beanTomap(Object bean) throws Exception {
        PropertyDescriptor[] pds;
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo b = Introspector.getBeanInfo(bean.getClass(), Object.class);
        for (PropertyDescriptor pd : pds = b.getPropertyDescriptors()) {
            String propertyName = pd.getName();
            Method m = pd.getReadMethod();
            Object properValue = m.invoke(bean, new Object[0]);
            map.put(propertyName, properValue);
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<?> clazz) throws Exception {
        Object obj = clazz.newInstance();
        if (map != null && !map.isEmpty() && map.size() > 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                Field field = ConvertUtil.getClassField(clazz, propertyName);
                if (field == null) continue;
                Class<?> fieldTypeClass = field.getType();
                value = ConvertUtil.convertValType(value, fieldTypeClass);
                try {
                    clazz.getMethod(setMethodName, field.getType()).invoke(obj, value);
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return (T)obj;
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        if (Object.class.getName().equals(clazz.getName())) {
            return null;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return ConvertUtil.getClassField(superClass, fieldName);
        }
        return null;
    }

    private static Object convertValType(Object value, Class<?> fieldTypeClass) {
        Object retVal = null;
        retVal = Long.class.getName().equals(fieldTypeClass.getName()) || Long.TYPE.getName().equals(fieldTypeClass.getName()) ? Long.valueOf(Long.parseLong(value.toString())) : (Integer.class.getName().equals(fieldTypeClass.getName()) || Integer.TYPE.getName().equals(fieldTypeClass.getName()) ? Integer.valueOf(Integer.parseInt(value.toString())) : (Float.class.getName().equals(fieldTypeClass.getName()) || Float.TYPE.getName().equals(fieldTypeClass.getName()) ? Float.valueOf(Float.parseFloat(value.toString())) : (Double.class.getName().equals(fieldTypeClass.getName()) || Double.TYPE.getName().equals(fieldTypeClass.getName()) ? Double.valueOf(Double.parseDouble(value.toString())) : value)));
        return retVal;
    }
}

