/*
 * Decompiled with CFR 0.152.
 */
package com.walker.common.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder {
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    private MapBuilder() {
    }

    public static MapBuilder create() {
        return new MapBuilder();
    }

    public MapBuilder put(String name, Object val) {
        this.map.put(name, val);
        return this;
    }

    public MapBuilder put(String name, boolean val) {
        this.map.put(name, val);
        return this;
    }

    public MapBuilder put(String name, int val) {
        this.map.put(name, val);
        return this;
    }

    public MapBuilder put(String name, long val) {
        this.map.put(name, val);
        return this;
    }

    public MapBuilder put(String name, double val) {
        this.map.put(name, val);
        return this;
    }

    public MapBuilder put(String name, float val) {
        this.map.put(name, Float.valueOf(val));
        return this;
    }

    public <T> MapBuilder put(String name, T val, boolean use) {
        if (use) {
            this.put(name, val);
        }
        return this;
    }

    public static Map<String, Object> map(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static <T> Map<String, T> mapT(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>();
        map.put(key, value);
        return map;
    }

    public Map<String, Object> build() {
        return this.map;
    }
}

